/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.setup.api;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InvalidObjectException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.silverpeas.setup.api.FileLogger;
import org.silverpeas.setup.api.SystemWrapper;

public class JBossServer
implements GroovyObject {
    private static long DEFAULT_TIMEOUT;
    private String cli;
    private String starter;
    private final String jbossHome;
    private boolean serverManagementAllIP;
    private File redirection;
    private long timeout;
    private FileLogger logger;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public JBossServer(String jbossHome) {
        String string;
        MetaClass metaClass;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object var3_3 = null;
        this.redirection = (File)ScriptBytecodeAdapter.castToType(var3_3, File.class);
        long l = DEFAULT_TIMEOUT;
        this.timeout = l;
        Object object = callSiteArray[0].call(FileLogger.class, callSiteArray[1].call(callSiteArray[2].callCurrent((GroovyObject)this)), callSiteArray[3].callGetProperty(System.class));
        this.logger = (FileLogger)ScriptBytecodeAdapter.castToType((Object)object, FileLogger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.jbossHome = string = jbossHome;
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(SystemWrapper.class, (Object)"os.name")), (Object)"win"), (Object)0)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/jboss-cli.bat"});
            this.cli = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/standalone.bat"});
            this.starter = ShortTypeHandling.castToString((Object)gStringImpl2);
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/jboss-cli.sh"});
            this.cli = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl3 = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/standalone.sh"});
            this.starter = ShortTypeHandling.castToString((Object)gStringImpl3);
        }
    }

    private void assertJBossIsRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callCurrent((GroovyObject)this))) {
                throw (Throwable)callSiteArray[8].callConstructor(AssertionError.class, (Object)"JBoss not running");
            }
        } else if (!this.isRunning()) {
            throw (Throwable)callSiteArray[9].callConstructor(AssertionError.class, (Object)"JBoss not running");
        }
    }

    private static void assertCommandSucceeds(Object command) throws AssertionError, InvalidObjectException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String result = ShortTypeHandling.castToString((Object)callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(command)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[12].call(command), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)result, (Object)"\"outcome\" => \"failed\""))) {
            boolean rollBacked = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)result, (Object)"\"rolled-back\" => true"));
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Execution Output: \n", ""}));
            if (!rollBacked) {
                throw (Throwable)callSiteArray[15].callConstructor(InvalidObjectException.class, (Object)msg);
            }
            throw (Throwable)callSiteArray[16].callConstructor(AssertionError.class, (Object)msg);
        }
    }

    private void waitUntilRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        callSiteArray[17].call((Object)this.logger, (Object)" %s", (Object)".");
        String status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[18].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            status = string = this.status();
        }
        long start = DefaultTypeTransformation.longUnbox((Object)callSiteArray[19].call(System.class));
        while (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callCurrent((GroovyObject)this, (Object)status))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callCurrent((GroovyObject)this, (Object)status))) {
                callSiteArray[22].callCurrent((GroovyObject)this);
            }
            callSiteArray[23].call(Thread.class, (Object)1000);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[24].call(callSiteArray[25].call(System.class), (Object)start), (Object)this.timeout)) {
                callSiteArray[26].call((Object)this.logger, (Object)"JBoss doesn't respond. Stop all");
                throw (Throwable)callSiteArray[27].callConstructor(TimeoutException.class, (Object)"JBoss doesn't respond. Stop all");
            }
            callSiteArray[28].call((Object)this.logger, (Object)"%s", (Object)".");
            Object object = callSiteArray[29].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        }
    }

    public void doWhenRunning(Closure action) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[30].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            status = string = this.status();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callCurrent((GroovyObject)this, (Object)status))) {
                callSiteArray[32].call((Object)this.logger, (Object)"JBoss not started, so start it");
                callSiteArray[33].callCurrent((GroovyObject)this);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].callCurrent((GroovyObject)this, (Object)status))) {
                callSiteArray[35].call((Object)this.logger, (Object)"JBoss is starting, so wait for it is running");
                callSiteArray[36].callCurrent((GroovyObject)this);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callCurrent((GroovyObject)this, (Object)status))) {
                callSiteArray[38].call((Object)this.logger, (Object)"JBoss asks for reload, so reloads it");
                Object proc = callSiteArray[39].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
                callSiteArray[40].call(proc);
                callSiteArray[41].callCurrent((GroovyObject)this);
            }
        } else if (this.stopped(status)) {
            callSiteArray[42].call((Object)this.logger, (Object)"JBoss not started, so start it");
            this.start();
        } else if (this.starting(status)) {
            callSiteArray[43].call((Object)this.logger, (Object)"JBoss is starting, so wait for it is running");
            this.waitUntilRunning();
        } else if (this.reloadRequired(status)) {
            callSiteArray[44].call((Object)this.logger, (Object)"JBoss asks for reload, so reloads it");
            Object proc = callSiteArray[45].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
            callSiteArray[46].call(proc);
            this.waitUntilRunning();
        }
        callSiteArray[47].call((Object)action);
    }

    public JBossServer redirectOutputTo(File log) {
        File file;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.redirection = file = log;
        return this;
    }

    public JBossServer useLogger(Object logger) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object object = logger;
        this.logger = (FileLogger)ScriptBytecodeAdapter.castToType((Object)object, FileLogger.class);
        return this;
    }

    public JBossServer withStartingTimeout(long timeout) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (timeout > (long)0) {
                long l = timeout;
                this.timeout = l;
            }
        } else if (timeout > (long)0) {
            long l = timeout;
            this.timeout = l;
        }
        return this;
    }

    public JBossServer setServerManagementAllIP(boolean isAllIp) {
        boolean bl;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.serverManagementAllIP = bl = isAllIp;
        return this;
    }

    public String about() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object proc = callSiteArray[48].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --commands=:read-attribute(name=product-name),:read-attribute(name=product-version)"}));
        callSiteArray[49].call(proc);
        Reference about = new Reference((Object)"");
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[50].call(proc), (Object)0)) {
            String output = ShortTypeHandling.castToString((Object)callSiteArray[51].callGetProperty(callSiteArray[52].callGetProperty(proc)));
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)output, (Object)"\"result\" => \"(.+)\""), Matcher.class);
            public final class _about_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference about;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _about_closure1(Object _outerInstance, Object _thisObject, Reference about) {
                    Reference reference;
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.about = reference = about;
                }

                public Object doCall(Object token) {
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    Object object = callSiteArray[0].call(this.about.get(), callSiteArray[1].call(callSiteArray[2].call(token, (Object)1), (Object)" "));
                    this.about.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                @Generated
                public String getAbout() {
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.about.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _about_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "plus";
                    stringArray[2] = "getAt";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _about_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_about_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _about_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[53].call((Object)matcher, (Object)new _about_closure1(this, this, about));
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].callGetProperty((Object)((String)about.get()))) ? "Unsupported or unknown application server" : callSiteArray[55].call((Object)((String)about.get()))));
    }

    public void start(Map params) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        int managementPort = 9990;
        boolean adminOnly = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)params, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGetProperty((Object)params)) ? callSiteArray[57].callGetProperty((Object)params) : Boolean.valueOf(false)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callCurrent((GroovyObject)this))) {
                callSiteArray[59].callCurrent((GroovyObject)this);
                callSiteArray[60].callCurrent((GroovyObject)this);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].callCurrent((GroovyObject)this))) {
            this.reload();
            this.stop();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].callCurrent((GroovyObject)this))) {
                ProcessBuilder process = null;
                if (adminOnly) {
                    Object object = callSiteArray[63].callConstructor(ProcessBuilder.class, (Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"--admin-only");
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else if (this.serverManagementAllIP) {
                    Object object = callSiteArray[64].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0"));
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[65].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0"));
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                callSiteArray[66].call(callSiteArray[67].call((Object)process, callSiteArray[68].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[69].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[70].call((Object)process);
                    callSiteArray[71].call(System.class, callSiteArray[72].call((Object)process));
                }
                callSiteArray[73].call((Object)process);
                callSiteArray[74].callCurrent((GroovyObject)this);
                if (this.serverManagementAllIP) {
                    callSiteArray[75].callCurrent((GroovyObject)this, (Object)"");
                    callSiteArray[76].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
            } else {
                callSiteArray[77].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        } else if (!this.isStartingOrRunning()) {
            ProcessBuilder process = null;
            if (adminOnly) {
                Object object = callSiteArray[78].callConstructor(ProcessBuilder.class, (Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"--admin-only");
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            } else if (this.serverManagementAllIP) {
                Object object = callSiteArray[79].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0"));
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            } else {
                Object object = callSiteArray[80].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0"));
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            }
            callSiteArray[81].call(callSiteArray[82].call((Object)process, callSiteArray[83].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                callSiteArray[84].call((Object)process, (Object)this.redirection);
            } else {
                callSiteArray[85].call((Object)process);
                callSiteArray[86].call(System.class, callSiteArray[87].call((Object)process));
            }
            callSiteArray[88].call((Object)process);
            this.waitUntilRunning();
            if (this.serverManagementAllIP) {
                callSiteArray[89].callCurrent((GroovyObject)this, (Object)"");
                callSiteArray[90].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
            }
        } else {
            callSiteArray[91].call((Object)this.logger, (Object)"A JBoss instance is already started");
        }
    }

    public void debug(int port) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callCurrent((GroovyObject)this))) {
                callSiteArray[93].callCurrent((GroovyObject)this);
                callSiteArray[94].callCurrent((GroovyObject)this);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].callCurrent((GroovyObject)this))) {
                int managementPort = 9990;
                String p = ShortTypeHandling.castToString((Object)(port <= 1000 ? "5005" : callSiteArray[96].call(String.class, (Object)port)));
                ProcessBuilder process = null;
                if (this.serverManagementAllIP) {
                    Object object = callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[100].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[101].call(callSiteArray[102].call(callSiteArray[103].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[104].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[105].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[106].call((Object)process);
                    callSiteArray[107].call(System.class, callSiteArray[108].call((Object)process));
                }
                callSiteArray[109].call((Object)process);
                callSiteArray[110].callCurrent((GroovyObject)this);
                callSiteArray[111].callCurrent((GroovyObject)this, (Object)"");
                if (this.serverManagementAllIP) {
                    callSiteArray[112].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
                callSiteArray[113].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{p}, new String[]{"Silverpeas Debugging Port is ", ""}));
            } else {
                callSiteArray[114].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        } else {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].callCurrent((GroovyObject)this))) {
                this.reload();
                this.stop();
            }
            if (!this.isStartingOrRunning()) {
                int managementPort = 9990;
                String p = ShortTypeHandling.castToString((Object)(port <= 1000 ? "5005" : callSiteArray[116].call(String.class, (Object)port)));
                ProcessBuilder process = null;
                if (this.serverManagementAllIP) {
                    Object object = callSiteArray[117].call(callSiteArray[118].call(callSiteArray[119].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[120].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[124].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[125].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[126].call((Object)process);
                    callSiteArray[127].call(System.class, callSiteArray[128].call((Object)process));
                }
                callSiteArray[129].call((Object)process);
                this.waitUntilRunning();
                callSiteArray[130].callCurrent((GroovyObject)this, (Object)"");
                if (this.serverManagementAllIP) {
                    callSiteArray[131].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
                callSiteArray[132].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{p}, new String[]{"Silverpeas Debugging Port is ", ""}));
            } else {
                callSiteArray[133].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        }
    }

    public void stop() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].callCurrent((GroovyObject)this))) {
                Object proc = callSiteArray[135].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:shutdown"}));
                callSiteArray[136].call(proc);
            } else {
                callSiteArray[137].call((Object)this.logger, (Object)"No JBoss instance running");
            }
        } else if (this.isStartingOrRunning()) {
            Object proc = callSiteArray[138].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:shutdown"}));
            callSiteArray[139].call(proc);
        } else {
            callSiteArray[140].call((Object)this.logger, (Object)"No JBoss instance running");
        }
    }

    public void reload() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object proc = callSiteArray[141].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
        callSiteArray[142].call(proc);
    }

    private boolean running(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"running");
    }

    private boolean starting(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"starting");
    }

    private boolean stopped(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"stopped");
    }

    private boolean reloadRequired(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"reload-required");
    }

    public boolean isRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].callCurrent((GroovyObject)this, callSiteArray[144].callCurrent((GroovyObject)this)));
        }
        return this.running(this.status());
    }

    public boolean isStarting() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].callCurrent((GroovyObject)this, callSiteArray[146].callCurrent((GroovyObject)this)));
        }
        return this.starting(this.status());
    }

    public boolean isStartingOrRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            String status = ShortTypeHandling.castToString((Object)callSiteArray[147].callCurrent((GroovyObject)this));
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[148].callCurrent((GroovyObject)this, (Object)status)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[149].callCurrent((GroovyObject)this, (Object)status));
        }
        String status = this.status();
        return this.starting(status) || this.running(status);
    }

    public boolean isStopped() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callCurrent((GroovyObject)this, callSiteArray[151].callCurrent((GroovyObject)this)));
        }
        return this.stopped(this.status());
    }

    public String status() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        StringBuilder output = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].callConstructor(StringBuilder.class), StringBuilder.class);
        Object proc = callSiteArray[153].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:read-attribute(name=server-state)"}));
        callSiteArray[154].call(proc, (Object)output, (Object)output);
        Reference status = new Reference((Object)"stopped");
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[155].call(proc), (Object)0)) {
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)callSiteArray[156].call((Object)output), (Object)"\"result\" => \"(.+)\""), Matcher.class);
            public final class _status_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference status;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _status_closure2(Object _outerInstance, Object _thisObject, Reference status) {
                    Reference reference;
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.status = reference = status;
                }

                public Object doCall(Object token) {
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    Object object = callSiteArray[0].call(token, (Object)1);
                    this.status.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                @Generated
                public String getStatus() {
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.status.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _status_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getAt";
                    return new CallSiteArray(_status_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _status_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[157].call((Object)matcher, (Object)new _status_closure2(this, this, status));
        }
        return (String)status.get();
    }

    public boolean isAlreadyConfigured() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String config = ShortTypeHandling.castToString((Object)callSiteArray[158].callGetProperty(callSiteArray[159].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.jbossHome}, new String[]{"", "/standalone/configuration/standalone-full.xml"}))));
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[160].call((Object)config, (Object)"java:/datasources/DocumentStore")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[161].call((Object)config, (Object)"java:/datasources/silverpeas"));
    }

    public void add(String artifactPath) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String artifactName = ShortTypeHandling.castToString((Object)callSiteArray[162].callGetProperty(callSiteArray[163].call(Paths.class, (Object)artifactPath)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[164].callCurrent((GroovyObject)this, (Object)artifactPath, (Object)artifactName);
        } else {
            this.add(artifactPath, artifactName);
        }
    }

    public void add(String artifactPath, String context) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String artifactName = ShortTypeHandling.castToString((Object)callSiteArray[165].call(FilenameUtils.class, (Object)artifactPath));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[166].callCurrent((GroovyObject)this, (Object)artifactPath, (Object)artifactName, (Object)context);
        } else {
            this.add(artifactPath, artifactName, context);
        }
    }

    public void add(String artifactPath, String name, String context) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String normalizedArtifactPath = ShortTypeHandling.castToString((Object)callSiteArray[167].call(FilenameUtils.class, (Object)artifactPath));
        Path artifactTruePath = (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].call(Paths.class, (Object)normalizedArtifactPath), Path.class);
        boolean archive = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[169].call(Files.class, (Object)artifactTruePath));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[170].callCurrent((GroovyObject)this, (Object)name))) {
                Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{name, context, normalizedArtifactPath, archive}, new String[]{"/deployment=", ":add(runtime-name=", ",content=[{path=>", ",archive=", "}])"}), callSiteArray[172].callGetProperty(SystemUtils.class)), Process.class);
                callSiteArray[173].call((Object)proc);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[174].call((Object)proc), (Object)0) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[175].callCurrent((GroovyObject)this, (Object)name))) {
                    throw (Throwable)callSiteArray[176].callConstructor(RuntimeException.class, callSiteArray[177].call((Object)new GStringImpl(new Object[]{name}, new String[]{"Adding of ", " in JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[178].call((Object)proc), callSiteArray[179].callGetProperty(callSiteArray[180].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
                }
            } else {
                callSiteArray[181].call((Object)this.logger, (Object)new GStringImpl(new Object[]{name}, new String[]{"", " is already added in JBoss"}));
            }
        } else if (!this.isInDeployments(name)) {
            Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[182].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{name, context, normalizedArtifactPath, archive}, new String[]{"/deployment=", ":add(runtime-name=", ",content=[{path=>", ",archive=", "}])"}), callSiteArray[183].callGetProperty(SystemUtils.class)), Process.class);
            callSiteArray[184].call((Object)proc);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[185].call((Object)proc), (Object)0) || !this.isInDeployments(name)) {
                throw (Throwable)callSiteArray[186].callConstructor(RuntimeException.class, callSiteArray[187].call((Object)new GStringImpl(new Object[]{name}, new String[]{"Adding of ", " in JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[188].call((Object)proc), callSiteArray[189].callGetProperty(callSiteArray[190].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else {
            callSiteArray[191].call((Object)this.logger, (Object)new GStringImpl(new Object[]{name}, new String[]{"", " is already added in JBoss"}));
        }
    }

    public void remove(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[192].callCurrent((GroovyObject)this, (Object)artifact))) {
                Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"undeploy ", ""})), Process.class);
                callSiteArray[194].call((Object)proc);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[195].call((Object)proc), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[196].callCurrent((GroovyObject)this, (Object)artifact))) {
                    throw (Throwable)callSiteArray[197].callConstructor(RuntimeException.class, callSiteArray[198].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Remove of ", " from JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[199].call((Object)proc), callSiteArray[200].callGetProperty(callSiteArray[201].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
                }
            } else {
                callSiteArray[202].call((Object)this.logger, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"", " isn't deployed in JBoss"}));
            }
        } else if (this.isInDeployments(artifact)) {
            Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"undeploy ", ""})), Process.class);
            callSiteArray[204].call((Object)proc);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[205].call((Object)proc), (Object)0) || this.isInDeployments(artifact)) {
                throw (Throwable)callSiteArray[206].callConstructor(RuntimeException.class, callSiteArray[207].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Remove of ", " from JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[208].call((Object)proc), callSiteArray[209].callGetProperty(callSiteArray[210].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else {
            callSiteArray[211].call((Object)this.logger, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"", " isn't deployed in JBoss"}));
        }
    }

    public void deploy(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":deploy()"})), Process.class);
        callSiteArray[213].call((Object)proc);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[214].call((Object)proc), (Object)0) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[215].callCurrent((GroovyObject)this, (Object)artifact))) {
                throw (Throwable)callSiteArray[216].callConstructor(RuntimeException.class, callSiteArray[217].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[218].call((Object)proc), callSiteArray[219].callGetProperty(callSiteArray[220].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[221].call((Object)proc), (Object)0) || !this.isDeployed(artifact)) {
            throw (Throwable)callSiteArray[222].callConstructor(RuntimeException.class, callSiteArray[223].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[224].call((Object)proc), callSiteArray[225].callGetProperty(callSiteArray[226].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
        }
    }

    public void undeploy(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[227].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":undeploy()"})), Process.class);
        callSiteArray[228].call((Object)proc);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[229].call((Object)proc), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[230].callCurrent((GroovyObject)this, (Object)artifact))) {
                throw (Throwable)callSiteArray[231].callConstructor(RuntimeException.class, callSiteArray[232].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[233].call((Object)proc), callSiteArray[234].callGetProperty(callSiteArray[235].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[236].call((Object)proc), (Object)0) || this.isDeployed(artifact)) {
            throw (Throwable)callSiteArray[237].callConstructor(RuntimeException.class, callSiteArray[238].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[239].call((Object)proc), callSiteArray[240].callGetProperty(callSiteArray[241].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
        }
    }

    public boolean isDeployed(String artifact) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[242].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":read-attribute(name=enabled)"})), Process.class);
        callSiteArray[243].call((Object)proc);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[244].call(callSiteArray[245].callGetProperty(callSiteArray[246].callGetProperty((Object)proc)), (Object)"\"result\" => true"));
    }

    public boolean isInDeployments(String artifact) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[247].callCurrent((GroovyObject)this, (Object)"ls deployment");
            proc = (Process)ScriptBytecodeAdapter.castToType((Object)object, Process.class);
        } else {
            Process process;
            proc = process = this.executeCliCommand("ls deployment");
        }
        callSiteArray[248].call((Object)proc);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[249].call(callSiteArray[250].callGetProperty(callSiteArray[251].callGetProperty((Object)proc)), (Object)artifact));
    }

    public void processCommandFile(File commandsFile) throws Exception {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        try {
            callSiteArray[252].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[253].callGetProperty((Object)commandsFile)}, new String[]{"", " processing..."}));
            Object proc = callSiteArray[254].call((Object)new GStringImpl(new Object[]{this.cli, callSiteArray[255].callGetProperty((Object)commandsFile)}, new String[]{"", " --connect --file=", ""}));
            callSiteArray[256].call(proc);
            callSiteArray[257].callStatic(JBossServer.class, proc);
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[258].callCurrent((GroovyObject)this), (Object)"starting")) {
                    callSiteArray[259].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[260].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloading..."}));
                    while (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[261].callCurrent((GroovyObject)this))) {
                        callSiteArray[262].callCurrent((GroovyObject)this, (Object)1000);
                    }
                    callSiteArray[263].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[264].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloaded"}));
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)this.status(), (Object)"starting")) {
                callSiteArray[265].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[266].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloading..."}));
                while (!this.isRunning()) {
                    callSiteArray[267].callCurrent((GroovyObject)this, (Object)1000);
                }
                callSiteArray[268].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[269].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloaded"}));
            }
            callSiteArray[270].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[271].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [OK]"}));
        }
        catch (InvalidObjectException e) {
            callSiteArray[272].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[273].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [WARNING]"}));
            callSiteArray[274].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[275].callGetProperty((Object)e)}, new String[]{"Invalid resource. ", ""}));
        }
        catch (AssertionError e) {
            callSiteArray[276].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[277].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [FAILURE]"}));
            callSiteArray[278].call((Object)this.logger, callSiteArray[279].callGetProperty((Object)e));
            throw (Throwable)((Object)e);
        }
        catch (Exception e) {
            callSiteArray[280].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[281].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [FAILURE]"}));
            callSiteArray[282].call((Object)this.logger, callSiteArray[283].callGetProperty((Object)e));
            throw (Throwable)e;
        }
    }

    public Process executeCliCommand(String commands, boolean wrapIntoDoubleQuotes) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String finalCommands = commands;
        if (wrapIntoDoubleQuotes) {
            Object object = callSiteArray[284].call(callSiteArray[285].call((Object)"\"", (Object)finalCommands), (Object)"\"");
            finalCommands = ShortTypeHandling.castToString((Object)object);
        }
        return (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[286].call(callSiteArray[287].call(callSiteArray[288].callConstructor(ProcessBuilder.class, (Object)this.cli, (Object)"--connect", (Object)finalCommands), (Object)true)), Process.class);
    }

    @Generated
    public void start() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.start(null);
    }

    @Generated
    public void debug() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.debug(5005);
        } else {
            this.debug(5005);
        }
    }

    @Generated
    public Process executeCliCommand(String commands) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.executeCliCommand(commands, false);
        }
        return this.executeCliCommand(commands, false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JBossServer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = l = 300000L;
    }

    static {
        long l;
        JBossServer.__$swapInit();
        DEFAULT_TIMEOUT = l = 300000L;
    }

    @Generated
    public static long getDEFAULT_TIMEOUT() {
        return DEFAULT_TIMEOUT;
    }

    @Generated
    public static void setDEFAULT_TIMEOUT(long l) {
        DEFAULT_TIMEOUT = l;
    }

    @Generated
    public final String getJbossHome() {
        return this.jbossHome;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "getSimpleName";
        stringArray[2] = "getClass";
        stringArray[3] = "out";
        stringArray[4] = "indexOf";
        stringArray[5] = "toLowerCase";
        stringArray[6] = "getProperty";
        stringArray[7] = "isRunning";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "text";
        stringArray[11] = "in";
        stringArray[12] = "exitValue";
        stringArray[13] = "contains";
        stringArray[14] = "contains";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "formatInfo";
        stringArray[18] = "status";
        stringArray[19] = "currentTimeMillis";
        stringArray[20] = "running";
        stringArray[21] = "reloadRequired";
        stringArray[22] = "reload";
        stringArray[23] = "sleep";
        stringArray[24] = "minus";
        stringArray[25] = "currentTimeMillis";
        stringArray[26] = "error";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "formatInfo";
        stringArray[29] = "status";
        stringArray[30] = "status";
        stringArray[31] = "stopped";
        stringArray[32] = "info";
        stringArray[33] = "start";
        stringArray[34] = "starting";
        stringArray[35] = "info";
        stringArray[36] = "waitUntilRunning";
        stringArray[37] = "reloadRequired";
        stringArray[38] = "info";
        stringArray[39] = "execute";
        stringArray[40] = "waitFor";
        stringArray[41] = "waitUntilRunning";
        stringArray[42] = "info";
        stringArray[43] = "info";
        stringArray[44] = "info";
        stringArray[45] = "execute";
        stringArray[46] = "waitFor";
        stringArray[47] = "call";
        stringArray[48] = "execute";
        stringArray[49] = "waitFor";
        stringArray[50] = "exitValue";
        stringArray[51] = "text";
        stringArray[52] = "in";
        stringArray[53] = "each";
        stringArray[54] = "empty";
        stringArray[55] = "trim";
        stringArray[56] = "adminOnly";
        stringArray[57] = "adminOnly";
        stringArray[58] = "reloadRequired";
        stringArray[59] = "reload";
        stringArray[60] = "stop";
        stringArray[61] = "reloadRequired";
        stringArray[62] = "isStartingOrRunning";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "redirectErrorStream";
        stringArray[67] = "directory";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "redirectOutput";
        stringArray[70] = "inheritIO";
        stringArray[71] = "println";
        stringArray[72] = "redirectOutput";
        stringArray[73] = "start";
        stringArray[74] = "waitUntilRunning";
        stringArray[75] = "println";
        stringArray[76] = "println";
        stringArray[77] = "info";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "redirectErrorStream";
        stringArray[82] = "directory";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "redirectOutput";
        stringArray[85] = "inheritIO";
        stringArray[86] = "println";
        stringArray[87] = "redirectOutput";
        stringArray[88] = "start";
        stringArray[89] = "println";
        stringArray[90] = "println";
        stringArray[91] = "info";
        stringArray[92] = "reloadRequired";
        stringArray[93] = "reload";
        stringArray[94] = "stop";
        stringArray[95] = "isStartingOrRunning";
        stringArray[96] = "valueOf";
        stringArray[97] = "redirectErrorStream";
        stringArray[98] = "directory";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "redirectErrorStream";
        stringArray[102] = "directory";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "redirectOutput";
        stringArray[106] = "inheritIO";
        stringArray[107] = "println";
        stringArray[108] = "redirectOutput";
        stringArray[109] = "start";
        stringArray[110] = "waitUntilRunning";
        stringArray[111] = "println";
        stringArray[112] = "println";
        stringArray[113] = "println";
        stringArray[114] = "info";
        stringArray[115] = "reloadRequired";
        stringArray[116] = "valueOf";
        stringArray[117] = "redirectErrorStream";
        stringArray[118] = "directory";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "<$constructor$>";
        stringArray[121] = "redirectErrorStream";
        stringArray[122] = "directory";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "redirectOutput";
        stringArray[126] = "inheritIO";
        stringArray[127] = "println";
        stringArray[128] = "redirectOutput";
        stringArray[129] = "start";
        stringArray[130] = "println";
        stringArray[131] = "println";
        stringArray[132] = "println";
        stringArray[133] = "info";
        stringArray[134] = "isStartingOrRunning";
        stringArray[135] = "execute";
        stringArray[136] = "waitFor";
        stringArray[137] = "info";
        stringArray[138] = "execute";
        stringArray[139] = "waitFor";
        stringArray[140] = "info";
        stringArray[141] = "execute";
        stringArray[142] = "waitFor";
        stringArray[143] = "running";
        stringArray[144] = "status";
        stringArray[145] = "starting";
        stringArray[146] = "status";
        stringArray[147] = "status";
        stringArray[148] = "starting";
        stringArray[149] = "running";
        stringArray[150] = "stopped";
        stringArray[151] = "status";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "execute";
        stringArray[154] = "waitForProcessOutput";
        stringArray[155] = "exitValue";
        stringArray[156] = "toString";
        stringArray[157] = "each";
        stringArray[158] = "text";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "contains";
        stringArray[161] = "contains";
        stringArray[162] = "fileName";
        stringArray[163] = "get";
        stringArray[164] = "add";
        stringArray[165] = "getName";
        stringArray[166] = "add";
        stringArray[167] = "separatorsToUnix";
        stringArray[168] = "get";
        stringArray[169] = "isRegularFile";
        stringArray[170] = "isInDeployments";
        stringArray[171] = "executeCliCommand";
        stringArray[172] = "IS_OS_WINDOWS";
        stringArray[173] = "waitFor";
        stringArray[174] = "exitValue";
        stringArray[175] = "isInDeployments";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "plus";
        stringArray[178] = "exitValue";
        stringArray[179] = "text";
        stringArray[180] = "in";
        stringArray[181] = "info";
        stringArray[182] = "executeCliCommand";
        stringArray[183] = "IS_OS_WINDOWS";
        stringArray[184] = "waitFor";
        stringArray[185] = "exitValue";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "plus";
        stringArray[188] = "exitValue";
        stringArray[189] = "text";
        stringArray[190] = "in";
        stringArray[191] = "info";
        stringArray[192] = "isInDeployments";
        stringArray[193] = "executeCliCommand";
        stringArray[194] = "waitFor";
        stringArray[195] = "exitValue";
        stringArray[196] = "isInDeployments";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "plus";
        stringArray[199] = "exitValue";
        stringArray[200] = "text";
        stringArray[201] = "in";
        stringArray[202] = "info";
        stringArray[203] = "executeCliCommand";
        stringArray[204] = "waitFor";
        stringArray[205] = "exitValue";
        stringArray[206] = "<$constructor$>";
        stringArray[207] = "plus";
        stringArray[208] = "exitValue";
        stringArray[209] = "text";
        stringArray[210] = "in";
        stringArray[211] = "info";
        stringArray[212] = "executeCliCommand";
        stringArray[213] = "waitFor";
        stringArray[214] = "exitValue";
        stringArray[215] = "isDeployed";
        stringArray[216] = "<$constructor$>";
        stringArray[217] = "plus";
        stringArray[218] = "exitValue";
        stringArray[219] = "text";
        stringArray[220] = "in";
        stringArray[221] = "exitValue";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "plus";
        stringArray[224] = "exitValue";
        stringArray[225] = "text";
        stringArray[226] = "in";
        stringArray[227] = "executeCliCommand";
        stringArray[228] = "waitFor";
        stringArray[229] = "exitValue";
        stringArray[230] = "isDeployed";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "plus";
        stringArray[233] = "exitValue";
        stringArray[234] = "text";
        stringArray[235] = "in";
        stringArray[236] = "exitValue";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "plus";
        stringArray[239] = "exitValue";
        stringArray[240] = "text";
        stringArray[241] = "in";
        stringArray[242] = "executeCliCommand";
        stringArray[243] = "waitFor";
        stringArray[244] = "contains";
        stringArray[245] = "text";
        stringArray[246] = "in";
        stringArray[247] = "executeCliCommand";
        stringArray[248] = "waitFor";
        stringArray[249] = "contains";
        stringArray[250] = "text";
        stringArray[251] = "in";
        stringArray[252] = "info";
        stringArray[253] = "name";
        stringArray[254] = "execute";
        stringArray[255] = "path";
        stringArray[256] = "waitFor";
        stringArray[257] = "assertCommandSucceeds";
        stringArray[258] = "status";
        stringArray[259] = "info";
        stringArray[260] = "name";
        stringArray[261] = "isRunning";
        stringArray[262] = "sleep";
        stringArray[263] = "info";
        stringArray[264] = "name";
        stringArray[265] = "info";
        stringArray[266] = "name";
        stringArray[267] = "sleep";
        stringArray[268] = "info";
        stringArray[269] = "name";
        stringArray[270] = "info";
        stringArray[271] = "name";
        stringArray[272] = "info";
        stringArray[273] = "name";
        stringArray[274] = "warn";
        stringArray[275] = "message";
        stringArray[276] = "info";
        stringArray[277] = "name";
        stringArray[278] = "error";
        stringArray[279] = "message";
        stringArray[280] = "info";
        stringArray[281] = "name";
        stringArray[282] = "error";
        stringArray[283] = "message";
        stringArray[284] = "plus";
        stringArray[285] = "plus";
        stringArray[286] = "start";
        stringArray[287] = "redirectErrorStream";
        stringArray[288] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[289];
        JBossServer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(JBossServer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = JBossServer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

