/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.util.Collection;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.notification.AlbumMediaEventNotifier;
import org.silverpeas.components.gallery.process.AbstractGalleryDataProcess;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.StringUtil;

public class GalleryDeleteMediaDataProcess
extends AbstractGalleryDataProcess {
    private Collection<String> albumIds;

    protected GalleryDeleteMediaDataProcess(Media media) {
        super(media);
    }

    public static GalleryDeleteMediaDataProcess getInstance(Media media) {
        return new GalleryDeleteMediaDataProcess(media);
    }

    @Override
    protected void processData(ProcessExecutionContext context, ProcessSession session) throws Exception {
        this.albumIds = MediaDAO.getAlbumIdsOf(this.getMedia());
        MediaDAO.deleteMedia(this.getMedia());
        this.removeXMLContentOfMedia(this.getMedia().getId(), context);
        MediaPK mediaPK = this.getMedia().getMediaPK();
        CommentServiceProvider.getCommentService().deleteAllCommentsOnResource(this.getMedia().getContributionType(), new ResourceReference((WAPrimaryKey)mediaPK));
        this.getGalleryContentManager().deleteSilverContent((Contribution)this.getMedia());
    }

    private void removeXMLContentOfMedia(String mediaId, ProcessExecutionContext context) {
        try {
            String xmlFormName = this.getXMLFormName(context);
            if (StringUtil.isDefined((String)xmlFormName)) {
                String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
                PublicationTemplate pubTemplate = this.getPublicationTemplateManager().getPublicationTemplate(context.getComponentInstanceId() + ":" + xmlFormShortName);
                RecordSet set = pubTemplate.getRecordSet();
                DataRecord data = set.getRecord(mediaId);
                if (data != null) {
                    set.delete(data.getId());
                }
            }
        }
        catch (FormException | PublicationTemplateException e) {
            throw new GalleryRuntimeException(e);
        }
    }

    public void onSuccessful() throws Exception {
        super.onSuccessful();
        AlbumMediaEventNotifier notifier = AlbumMediaEventNotifier.get();
        for (String albumId : this.albumIds) {
            notifier.notifyEventOn(ResourceEvent.Type.DELETION, new AlbumMedia[]{new AlbumMedia(albumId, this.getMedia())});
        }
    }
}

