/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.StringUtil;

class KmeliaUserTreeViewFilter {
    private static final String NODE_TO_EXCLUDE = "@@@NODE_TO_EXCLUDE@@@";
    private final OrganizationController orga = OrganizationController.get();
    private final String userId;
    private final String instanceId;
    private final NodePK initialNodeIdentifier;
    private final String bestUserComponentInstanceRole;
    private final boolean isRightsOnTopicsUsed;
    private Map<String, List<String>> nodeUserRoles = null;

    public static KmeliaUserTreeViewFilter from(String userId, String instanceId, NodePK initialNodeIdentifier, String bestUserComponentInstanceRole, boolean isRightsOnTopicsUsed) {
        return new KmeliaUserTreeViewFilter(userId, instanceId, initialNodeIdentifier, bestUserComponentInstanceRole, isRightsOnTopicsUsed);
    }

    private KmeliaUserTreeViewFilter(String userId, String instanceId, NodePK initialNodeIdentifier, String bestUserComponentInstanceRole, boolean isRightsOnTopicsUsed) {
        this.userId = userId;
        this.instanceId = instanceId;
        this.initialNodeIdentifier = initialNodeIdentifier;
        this.bestUserComponentInstanceRole = bestUserComponentInstanceRole;
        this.isRightsOnTopicsUsed = isRightsOnTopicsUsed;
    }

    void setBestUserRoleAndFilter(List<NodeDetail> tree) {
        String sNB;
        int nbPublisOnRoot;
        NodeDetail root;
        if (this.isRightsOnTopicsUsed) {
            tree.removeIf(node -> !this.setBestUserNodeRole((NodeDetail)node, this.bestUserComponentInstanceRole));
        } else {
            for (NodeDetail node2 : tree) {
                node2.setUserRole(this.bestUserComponentInstanceRole);
            }
        }
        if (!tree.isEmpty() && (root = tree.get(0)).getNodePK().isRoot() && (nbPublisOnRoot = Integer.parseInt(sNB = StringUtil.defaultStringIfNotDefined((String)this.orga.getComponentParameterValue(this.initialNodeIdentifier.getInstanceId(), "nbPubliOnRoot"), (String)"0"))) != 0) {
            root.setUserRole("user");
        }
    }

    private boolean setBestUserNodeRole(NodeDetail node, String bestParentNodeUserRole) {
        String nodeUserRole = node.getUserRole();
        if (nodeUserRole != null) {
            return !NODE_TO_EXCLUDE.equals(nodeUserRole);
        }
        String bestNodeUserRole = bestParentNodeUserRole;
        boolean hasUserNodeAccess = false;
        if (node.haveRights()) {
            String rightsDependsOn = node.getRightsDependsOn();
            Object[] profiles = this.getNodeUserRoles(rightsDependsOn);
            String string = bestNodeUserRole = ArrayUtil.isEmpty((Object[])profiles) ? null : KmeliaHelper.getProfile((String[])profiles);
        }
        if (bestNodeUserRole != null) {
            node.setUserRole(bestNodeUserRole);
            hasUserNodeAccess = true;
        }
        Iterator nodeChildIterator = node.getChildrenDetails().iterator();
        while (nodeChildIterator.hasNext()) {
            NodeDetail child = (NodeDetail)nodeChildIterator.next();
            boolean hasUserChildNodeAccess = this.setBestUserNodeRole(child, bestNodeUserRole);
            if (!hasUserChildNodeAccess) {
                nodeChildIterator.remove();
            }
            hasUserNodeAccess = hasUserNodeAccess || hasUserChildNodeAccess;
        }
        if (!hasUserNodeAccess) {
            node.setUserRole(NODE_TO_EXCLUDE);
        }
        return hasUserNodeAccess;
    }

    private String[] getNodeUserRoles(String nodeId) {
        List<String> roles;
        if (this.nodeUserRoles == null) {
            this.nodeUserRoles = this.orga.getUserObjectProfiles(this.userId, this.instanceId, ProfiledObjectType.NODE);
        }
        return (roles = this.nodeUserRoles.get(nodeId)) != null ? roles.toArray(new String[0]) : new String[]{};
    }
}

