/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.notification.FormsOnlineValidationRequestUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

public class FormsOnlinePendingValidationRequestUserNotification
extends FormsOnlineValidationRequestUserNotification {
    private final List<String> usersToBeNotified;
    private final List<String> groupsToBeNotified;

    public FormsOnlinePendingValidationRequestUserNotification(FormInstance resource) {
        super(resource, NotifAction.PENDING_VALIDATION);
        FormInstanceValidation pendingValidation = resource.getPendingValidation();
        if (pendingValidation != null) {
            if (pendingValidation.getValidationType().isHierarchical()) {
                String bossId = resource.getForm().getHierarchicalValidatorOfCurrentUser();
                this.usersToBeNotified = Collections.singletonList(bossId);
                this.groupsToBeNotified = Collections.emptyList();
            } else if (pendingValidation.getValidationType().isIntermediate()) {
                this.usersToBeNotified = this.extractUserIds(resource.getForm().getIntermediateReceiversAsUsers());
                this.groupsToBeNotified = this.extractGroupIds(resource.getForm().getIntermediateReceiversAsGroups());
            } else {
                this.usersToBeNotified = this.extractUserIds(resource.getForm().getReceiversAsUsers());
                this.groupsToBeNotified = this.extractGroupIds(resource.getForm().getReceiversAsGroups());
            }
        } else {
            this.usersToBeNotified = Collections.emptyList();
            this.groupsToBeNotified = Collections.emptyList();
        }
    }

    protected void perform(FormInstance resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    @Override
    protected String getBundleSubjectKey() {
        return "formsOnline.msgFormToValid";
    }

    @Override
    protected String getTemplateFileName() {
        return "notificationToValidate";
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        return this.usersToBeNotified;
    }

    protected Collection<String> getGroupIdsToNotify() {
        return this.groupsToBeNotified;
    }

    @Override
    protected int getCurrentValidationStep() {
        return super.getCurrentValidationStep() + 1;
    }
}

