/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;

abstract class AbstractFormsOnlineFormUserNotification
extends AbstractTemplateUserNotificationBuilder<FormDetail> {
    private final User user;

    AbstractFormsOnlineFormUserNotification(FormDetail form, User user) {
        super((Object)form);
        this.user = user;
    }

    protected void performTemplateData(String language, FormDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, StringUtil.defaultStringIfNotDefined((String)this.getTitle(language), (String)this.getTitle()), "");
        template.setAttribute("form", (Object)resource);
        template.setAttribute("senderName", (Object)(this.user != null ? this.user.getDisplayedName() : ""));
    }

    protected void performNotificationResource(String language, FormDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(false);
        notificationResourceData.setResourceName(resource.getName());
    }

    protected void perform(FormDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getResourceURL(FormDetail resource) {
        return URLUtil.getComponentInstanceURL((String)resource.getInstanceId()) + "/NewRequest?FormId=" + resource.getId();
    }

    protected String getTemplatePath() {
        return "formsonline";
    }

    protected String getComponentInstanceId() {
        return ((FormDetail)this.getResource()).getInstanceId();
    }

    protected String getSender() {
        return this.user.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.formsonline.multilang.formsOnlineBundle";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "formsOnline.Preview";
    }
}

