/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.silverpeas.components.mydb.service.MyDBConnectionInfoService;
import org.silverpeas.components.mydb.service.MyDBException;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.util.StringUtil;

@Entity
@NamedQueries(value={@NamedQuery(name="MyDBConnectionInfo.findByInstanceId", query="select ds from MyDBConnectionInfo ds where ds.instanceId = :instanceId"), @NamedQuery(name="MyDBConnectionInfo.deleteByInstanceId", query="delete MyDBConnectionInfo where instanceId = :instanceId")})
@Table(name="sc_mydb_connectinfo")
public class MyDBConnectionInfo
extends BasicJpaEntity<MyDBConnectionInfo, UniqueIntegerIdentifier> {
    @Column(length=250, nullable=false)
    @NotNull
    private String dataSource;
    @Column(length=250)
    private String login;
    @Column(length=250)
    private String password;
    @Column(length=100)
    private String tableName;
    private int rowLimit = 0;
    @Column(length=50, nullable=false)
    @NotNull
    private String instanceId;

    public static MyDBConnectionInfo getById(String id) {
        return MyDBConnectionInfoService.get().getConnectionInfo(id);
    }

    public static List<MyDBConnectionInfo> getFromComponentInstance(String instanceId) {
        return MyDBConnectionInfoService.get().getConnectionInfoList(instanceId);
    }

    public static void removeFromComponentInstance(String instanceId) {
        MyDBConnectionInfoService.get().removeConnectionInfoOfComponentInstance(instanceId);
    }

    protected MyDBConnectionInfo() {
    }

    public MyDBConnectionInfo(String dataSource, String instanceId) {
        this.dataSource = dataSource;
        this.instanceId = instanceId;
    }

    public boolean isDefined() {
        return StringUtil.isDefined((String)this.dataSource) && StringUtil.isDefined((String)this.instanceId);
    }

    public MyDBConnectionInfo withDefaultTableName(String tableName) {
        this.setDefaultTableName(tableName.toLowerCase());
        return this;
    }

    public MyDBConnectionInfo withoutAnyDefaultTable() {
        this.setDefaultTableName(null);
        return this;
    }

    public MyDBConnectionInfo withDataMaxNumber(int maxNumber) {
        this.setDataMaxNumber(maxNumber);
        return this;
    }

    public MyDBConnectionInfo withLoginAndPassword(String login, String password) {
        this.setLoginAndPassword(login, password);
        return this;
    }

    public MyDBConnectionInfo withDataSourceName(String dataSourceName) {
        this.setDataSourceName(dataSourceName);
        return this;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getLogin() {
        return this.login == null ? "" : this.login;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getDefaultTableName() {
        return this.tableName;
    }

    public int getDataMaxNumber() {
        return this.rowLimit;
    }

    public boolean isDefaultTableNameDefined() {
        return StringUtil.isDefined((String)this.tableName);
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSource = dataSourceName;
    }

    public void setLoginAndPassword(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void setDefaultTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataMaxNumber(int maxNumber) {
        this.rowLimit = maxNumber <= 0 ? 0 : maxNumber;
    }

    public void save() {
        MyDBConnectionInfoService.get().saveConnectionInfo(this);
    }

    public void remove() {
        MyDBConnectionInfoService.get().removeConnectionInfo(this);
    }

    public Connection openConnection() throws MyDBException {
        try {
            DataSource ds = (DataSource)InitialContext.doLookup(this.getDataSourceName());
            return ds.getConnection(this.getLogin(), this.getPassword());
        }
        catch (SQLException | NamingException ex) {
            throw new MyDBException(ex.getMessage(), new String[0]);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void checkConnection() throws MyDBException {
        try (Connection connection = this.openConnection();){
            if (!connection.isValid(0)) {
                throw new MyDBException("No valid connexion with the data source " + this.getDataSourceName(), new String[0]);
            }
        }
        catch (SQLException e) {
            throw new MyDBException(e);
        }
    }
}

