/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.organizationchart.service;

import org.silverpeas.components.organizationchart.model.OrganizationalChart;
import org.silverpeas.components.organizationchart.model.OrganizationalChartType;
import org.silverpeas.components.organizationchart.service.AbstractOrganizationChartConfiguration;
import org.silverpeas.components.organizationchart.service.GroupOrganizationChartBuilder;
import org.silverpeas.components.organizationchart.service.GroupOrganizationChartConfiguration;
import org.silverpeas.components.organizationchart.service.LdapOrganizationChartBuilder;
import org.silverpeas.components.organizationchart.service.LdapOrganizationChartConfiguration;
import org.silverpeas.components.organizationchart.service.OrganizationChartService;
import org.silverpeas.core.annotation.Service;

@Service
class DefaultOrganizationChartService
implements OrganizationChartService {
    DefaultOrganizationChartService() {
    }

    @Override
    public OrganizationalChart getOrganizationChart(AbstractOrganizationChartConfiguration config, String base, OrganizationalChartType type) {
        OrganizationalChart organizationalChart;
        if (config instanceof LdapOrganizationChartConfiguration) {
            String baseOU = base;
            organizationalChart = LdapOrganizationChartBuilder.from((LdapOrganizationChartConfiguration)config).buildFor(baseOU, type);
        } else if (config instanceof GroupOrganizationChartConfiguration) {
            String groupId = base;
            organizationalChart = GroupOrganizationChartBuilder.from((GroupOrganizationChartConfiguration)config).buildFor(groupId, type);
        } else {
            throw new UnsupportedOperationException();
        }
        return organizationalChart;
    }
}

