/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import org.silverpeas.components.kmelia.notification.AbstractKmeliaUserNotification;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;

public abstract class AbstractKmeliaFolderUserNotification
extends AbstractKmeliaUserNotification<NodeDetail> {
    private final NotifAction action;

    protected AbstractKmeliaFolderUserNotification(NodeDetail resource, NotifAction action) {
        super(resource);
        this.action = action;
    }

    protected void performTemplateData(String language, NodeDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("path", (Object)this.getHTMLNodePath(resource.getFatherPK(), language));
        template.setAttribute("topic", (Object)resource);
        template.setAttribute("topicName", (Object)resource.getName(language));
        template.setAttribute("topicDescription", (Object)resource.getDescription(language));
    }

    protected void performNotificationResource(String language, NodeDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceId(resource.getId());
        notificationResourceData.setResourceType(resource.getNodeType());
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    protected boolean stopWhenNoUserToNotify() {
        return !NotifAction.REPORT.equals((Object)this.action);
    }

    protected String getResourceURL(NodeDetail resource) {
        return KmeliaHelper.getNodeUrl(resource);
    }

    protected final String getPath(String language) {
        if (((NodeDetail)this.getResource()).getNodePK() == null) {
            return "";
        }
        return this.getHTMLNodePath(((NodeDetail)this.getResource()).getNodePK(), language);
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((NodeDetail)this.getResource()).getNodePK().getInstanceId();
    }

    protected String getSender() {
        if (NotifAction.REPORT.equals((Object)this.action)) {
            return null;
        }
        return ((NodeDetail)this.getResource()).getCreatorId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifTopicLinkLabel";
    }

    protected void perform(NodeDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }
}

