/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service;

import java.util.List;
import javax.inject.Inject;
import org.silverpeas.components.mailinglist.model.MailingListComponent;
import org.silverpeas.components.mailinglist.service.job.MessageChecker;
import org.silverpeas.components.mailinglist.service.model.MailingListService;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class MailCheckerInitialize
implements Initialization {
    @Inject
    private MessageChecker messageChecker;
    @Inject
    private MailingListService mailingListService;
    private static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.mailinglist.notification");
    private static final int DEFAULT_FREQUENCY = 1;

    public int getFrequency() {
        return settings.getInteger("mail.check.frequency", 1);
    }

    public MessageChecker getMessageChecker() {
        return this.messageChecker;
    }

    public MailingListService getMailingListService() {
        return this.mailingListService;
    }

    public void init() throws Exception {
        try {
            MessageChecker checker = this.getMessageChecker();
            checker.unschedule();
            if (this.hasToCheckForNewMails()) {
                SilverLogger.getLogger((Object)this).debug("Check mails from mailing lists every " + this.getFrequency() + " minutes", new Object[0]);
                JobTrigger trigger = JobTrigger.triggerEvery((int)this.getFrequency(), (TimeUnit)TimeUnit.MINUTE);
                checker.schedule(trigger);
                List<MailingList> mailingLists = this.getMailingListService().listAllMailingLists();
                for (MailingList list : mailingLists) {
                    MailingListComponent component = new MailingListComponent(list.getComponentId());
                    checker.addMessageListener(component);
                }
            }
        }
        catch (SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean hasToCheckForNewMails() {
        return this.getFrequency() > 0;
    }
}

