/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.socialnetwork;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Streaming;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.components.gallery.service.MediaServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialMediaCommentProvider;

@Provider
public class SocialGalleryMediaComment
implements SocialMediaCommentProvider {
    private List<String> getListResourceType() {
        ArrayList<String> listResourceType = new ArrayList<String>();
        listResourceType.add(Photo.getResourceType());
        listResourceType.add(Video.getResourceType());
        listResourceType.add(Sound.getResourceType());
        listResourceType.add(Streaming.getResourceType());
        return listResourceType;
    }

    private List<SocialInformation> decorate(List<SocialInformationComment> listSocialInformation) {
        ArrayList<SocialInformation> info = new ArrayList<SocialInformation>(listSocialInformation.size());
        for (SocialInformationComment socialInformation : listSocialInformation) {
            String resourceId = socialInformation.getComment().getResourceReference().getLocalId();
            String instanceId = socialInformation.getComment().getComponentInstanceId();
            MediaPK mediaPk = new MediaPK(resourceId, instanceId);
            Media media = MediaServiceProvider.getMediaService().getMedia(mediaPk);
            socialInformation.setUrl("/Rgallery/" + media.getInstanceId() + "/" + media.getURL());
            socialInformation.setTitle(media.getTitle());
            info.add((SocialInformation)socialInformation);
        }
        return info;
    }

    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        List listSocialInformation = CommentServiceProvider.getCommentService().getSocialInformationCommentsListByUserId(this.getListResourceType(), userId, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        return this.decorate(listSocialInformation);
    }

    public List<SocialInformation> getSocialInformationListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "gallery")));
        List listSocialInformation = CommentServiceProvider.getCommentService().getSocialInformationCommentsListOfMyContacts(this.getListResourceType(), myContactsIds, instanceIds, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        return this.decorate(listSocialInformation);
    }
}

