/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.io.File;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.gallery.MediaUtil;
import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.components.gallery.process.AbstractGalleryFileProcess;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.logging.SilverLogger;

public class GalleryCreateMediaFileProcess
extends AbstractGalleryFileProcess {
    private final File file;
    private final FileItem fileItem;
    private final Watermark watermark;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected GalleryCreateMediaFileProcess(Media media, Object file, Watermark watermark) {
        super(media);
        if (file != null) {
            if (file instanceof FileItem) {
                this.fileItem = (FileItem)file;
                this.file = null;
            } else {
                if (!(file instanceof File)) throw new IllegalArgumentException("GalleryCreateMediaFileProcess() - parameter 'file' has to be a FileItem or File instance.");
                this.file = (File)file;
                this.fileItem = null;
            }
        } else {
            this.fileItem = null;
            this.file = null;
        }
        this.watermark = watermark;
    }

    public static GalleryCreateMediaFileProcess getInstance(Media media, Object file, Watermark watermark) {
        return new GalleryCreateMediaFileProcess(media, file, watermark);
    }

    public void processFiles(ProcessExecutionContext context, ProcessSession session, FileHandler fileHandler) throws Exception {
        switch (this.getMedia().getType()) {
            case Photo: {
                this.processPhotoMedia(fileHandler);
                break;
            }
            case Video: {
                this.processVideoMedia(fileHandler);
                break;
            }
            case Sound: {
                this.processSoundMedia(fileHandler);
                break;
            }
            default: {
                SilverLogger.getLogger((Object)((Object)this)).warn("{0} media type not taken into charge", new Object[]{this.getMedia().getType().getName()});
            }
        }
    }

    private void processSoundMedia(FileHandler fileHandler) throws Exception {
        Sound sound = this.getMedia().getSound();
        if (this.fileItem != null) {
            MediaUtil.processSound(fileHandler, sound, this.fileItem);
        } else {
            MediaUtil.processSound(fileHandler, sound, this.file);
        }
    }

    private void processVideoMedia(FileHandler fileHandler) throws Exception {
        Video video = this.getMedia().getVideo();
        if (this.fileItem != null) {
            MediaUtil.processVideo(fileHandler, video, this.fileItem);
        } else {
            MediaUtil.processVideo(fileHandler, video, this.file);
        }
    }

    private void processPhotoMedia(FileHandler fileHandler) throws Exception {
        Photo photo = this.getMedia().getPhoto();
        if (this.fileItem != null) {
            MediaUtil.processPhoto(fileHandler, photo, this.fileItem, this.watermark);
        } else {
            MediaUtil.processPhoto(fileHandler, photo, this.file, this.watermark);
        }
    }
}

