/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.components.gallery.constant.GalleryResourceURIs;
import org.silverpeas.components.gallery.constant.MediaMimeType;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MetaData;
import org.silverpeas.components.gallery.process.media.GalleryLoadMetaDataProcess;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.io.media.video.ThumbnailPeriod;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public abstract class InternalMedia
extends Media {
    private static final long serialVersionUID = 2070296932101933853L;
    private boolean downloadAuthorized = false;
    private String fileName;
    private long fileSize = 0L;
    private MediaMimeType fileMimeType = MediaMimeType.ERROR;
    private Period downloadPeriod = Period.UNDEFINED;
    private LinkedHashMap<String, MetaData> metaData = null;

    public InternalMedia() {
    }

    protected InternalMedia(InternalMedia other) {
        super(other);
        this.downloadAuthorized = other.downloadAuthorized;
        this.fileName = other.fileName;
        this.fileSize = other.fileSize;
        this.fileMimeType = other.fileMimeType;
        this.downloadPeriod = other.downloadPeriod;
        if (other.metaData != null) {
            this.metaData = new LinkedHashMap<String, MetaData>(other.metaData);
        }
    }

    public boolean isDownloadAuthorized() {
        return this.downloadAuthorized;
    }

    @Override
    public boolean isDownloadable() {
        boolean isDownloadable;
        Date dateOfDay = DateUtil.getDate();
        boolean bl = isDownloadable = this.isDownloadAuthorized() && this.isVisible(dateOfDay);
        if (isDownloadable && this.getDownloadPeriod().isDefined()) {
            isDownloadable = this.getDownloadPeriod().contains(dateOfDay);
        }
        return isDownloadable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public MediaMimeType getFileMimeType() {
        return this.fileMimeType;
    }

    public void setFileMimeType(MediaMimeType fileMimeType) {
        this.fileMimeType = fileMimeType != null ? fileMimeType : MediaMimeType.ERROR;
    }

    public void setDownloadAuthorized(boolean downloadAuthorized) {
        this.downloadAuthorized = downloadAuthorized;
    }

    public Period getDownloadPeriod() {
        return this.downloadPeriod;
    }

    public void setDownloadPeriod(Period downloadPeriod) {
        this.downloadPeriod = Period.check((Period)downloadPeriod);
    }

    @Override
    public String getApplicationThumbnailUrl(MediaResolution mediaResolution) {
        if (mediaResolution == null || mediaResolution == MediaResolution.ORIGINAL || mediaResolution == MediaResolution.NORMAL) {
            mediaResolution = MediaResolution.PREVIEW;
        }
        if (this.getType().isPhoto()) {
            return this.getPhotoThumbnailUrl(mediaResolution);
        }
        if (this.getType().isVideo()) {
            if (this.getVideoThumbnailUrl()) {
                return GalleryResourceURIs.buildVideoThumbnailURI(this, ThumbnailPeriod.Thumbnail0).toString();
            }
            return super.getApplicationThumbnailUrl(mediaResolution);
        }
        return super.getApplicationThumbnailUrl(mediaResolution);
    }

    private boolean getVideoThumbnailUrl() {
        SilverpeasFile thumbFile = SilverpeasFileProvider.getFile((String)FileUtils.getFile((String[])new String[]{Media.BASE_PATH.getPath(), this.getComponentInstanceId(), this.getWorkspaceSubFolderName(), "img0.jpg"}).getPath());
        return thumbFile != null && thumbFile.exists();
    }

    private String getPhotoThumbnailUrl(MediaResolution mediaResolution) {
        SilverpeasFile fileWatermark;
        if (MediaResolution.WATERMARK == mediaResolution && !(fileWatermark = this.getFile(MediaResolution.WATERMARK)).exists()) {
            return "";
        }
        if (StringUtil.isDefined((String)this.getFileName()) && this.isPreviewable()) {
            return GalleryResourceURIs.buildMediaContentURI(this, mediaResolution).toString();
        }
        String thumbnailUrl = URLUtil.getApplicationURL() + "/gallery/jsp/icons/notAvailable_" + MessageManager.getLanguage() + mediaResolution.getThumbnailSuffix() + ".jpg";
        return FilenameUtils.normalize((String)thumbnailUrl, (boolean)true);
    }

    @Override
    public SilverpeasFile getFile(MediaResolution mediaResolution, String size) {
        if (StringUtil.isNotDefined((String)this.getFileName())) {
            return SilverpeasFile.NO_FILE;
        }
        int maxSize = 2;
        ArrayList<Object> potentialFileNames = new ArrayList<Object>(2);
        potentialFileNames.add(this.getFileName());
        if (this.getType().isPhoto()) {
            String thumbnailSuffix = mediaResolution.getThumbnailSuffix();
            String originalFileExt = "." + FilenameUtils.getExtension((String)this.getFileName());
            if (mediaResolution == MediaResolution.NORMAL) {
                potentialFileNames.add(this.getId() + thumbnailSuffix + originalFileExt);
            } else if (StringUtil.isDefined((String)thumbnailSuffix)) {
                potentialFileNames.set(0, this.getId() + thumbnailSuffix + originalFileExt);
            }
            if (!".jpg".equalsIgnoreCase(originalFileExt)) {
                potentialFileNames.add(this.getId() + thumbnailSuffix + ".jpg");
            }
        }
        SilverpeasFile file = SilverpeasFile.NO_FILE;
        for (String string : potentialFileNames) {
            File physicalFile = FileUtils.getFile((String[])new String[]{Media.BASE_PATH.getPath(), this.getComponentInstanceId(), this.getWorkspaceSubFolderName(), string});
            if (potentialFileNames.size() > 1 && !physicalFile.exists()) continue;
            if (StringUtil.isDefined((String)size)) {
                physicalFile = Paths.get(physicalFile.getParentFile().getPath(), size, physicalFile.getName()).toFile();
            }
            file = SilverpeasFileProvider.getFile((String)physicalFile.getPath());
        }
        return file;
    }

    private Map<String, MetaData> getAllMetaData() {
        if (this.metaData == null) {
            this.metaData = new LinkedHashMap();
            try {
                GalleryLoadMetaDataProcess.load(this);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return this.metaData;
    }

    public void addMetaData(MetaData data) {
        this.getAllMetaData().put(data.getProperty(), data);
    }

    public MetaData getMetaData(String property) {
        return this.getAllMetaData().get(property);
    }

    public Collection<String> getMetaDataProperties() {
        Collection<MetaData> values = this.getAllMetaData().values();
        ArrayList<String> properties = new ArrayList<String>();
        for (MetaData meta : values) {
            if (meta == null) continue;
            properties.add(meta.getProperty());
        }
        return properties;
    }
}

