/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.notification.user;

import java.util.MissingResourceException;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.notification.user.AbstractGalleryUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.WebEncodeHelper;

public abstract class AbstractGalleryAlbumUserNotification
extends AbstractGalleryUserNotification<AlbumDetail> {
    private final User sender;

    AbstractGalleryAlbumUserNotification(AlbumDetail resource, User sender) {
        super(resource);
        this.sender = sender;
    }

    protected void perform(AlbumDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    @Override
    protected String getTemplatePath() {
        return "gallery";
    }

    protected String getComponentInstanceId() {
        return ((AlbumDetail)((Object)this.getResource())).getNodePK().getInstanceId();
    }

    protected String getSender() {
        return this.sender.getId();
    }

    @Override
    protected String getLocalizationBundlePath() {
        return "org.silverpeas.gallery.multilang.galleryBundle";
    }

    protected String getResourceURL(AlbumDetail resource) {
        String applicationURL = URLUtil.getApplicationURL();
        return StringUtil.defaultStringIfNotDefined((String)resource.getPermalink(), (String)applicationURL).substring(applicationURL.length());
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "gallery.album.link.label";
    }

    protected void performTemplateData(String language, AlbumDetail resource, SilverpeasTemplate template) {
        String title = this.getTitleByLanguage(language);
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("path", (Object)this.getPath(language));
        template.setAttribute("album", (Object)resource);
        template.setAttribute("albumName", (Object)resource.getName(language));
        template.setAttribute("albumDesc", (Object)resource.getDescription(language));
    }

    protected void performNotificationResource(String language, AlbumDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(false);
        notificationResourceData.setResourceId(resource.getId());
        notificationResourceData.setResourceType("Album");
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    private String getTitleByLanguage(String language) {
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            title = this.getTitle();
        }
        return title;
    }

    protected final String getPath(String language) {
        NodePK nodePK = ((AlbumDetail)((Object)this.getResource())).getNodePK();
        return WebEncodeHelper.javaStringToHtmlString((String)NodeService.get().getPath(nodePK).format(language));
    }
}

