/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.classifieds.service;

import java.util.Collection;
import javax.inject.Inject;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.model.ClassifiedsRuntimeException;
import org.silverpeas.components.classifieds.service.ClassifiedService;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class ScheduledUnpublishExpiredClassifieds
implements SchedulerEventListener,
Initialization {
    @Inject
    private Scheduler scheduler;
    @Inject
    private OrganizationController organizationController;
    @Inject
    private ClassifiedService classifiedService;
    public static final String CLASSIFIEDSENGINE_JOB_NAME = "ClassifiedsEngineJobDelete";

    public void init() throws Exception {
        try {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.classifieds.settings.classifiedsSettings");
            String cron = settings.getString("cronScheduledDeleteClassifieds");
            this.scheduler.unscheduleJob(CLASSIFIEDSENGINE_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            this.scheduler.scheduleJob(CLASSIFIEDSENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void doScheduledDeleteClassifieds() {
        try {
            String[] instanceIds = this.organizationController.getCompoId("classifieds");
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.classifieds.settings.classifiedsSettings");
            int defaultExpirationDelay = settings.getInteger("nbDaysForDeleteClassifieds");
            for (String string : instanceIds) {
                Collection<ClassifiedDetail> classifieds;
                int expirationDelay = defaultExpirationDelay;
                String string2 = "classifieds" + string;
                String specificExpirationDelay = this.organizationController.getComponentParameterValue(string2, "expirationDelay");
                if (StringUtil.isDefined((String)specificExpirationDelay) && StringUtil.isInteger((String)specificExpirationDelay)) {
                    expirationDelay = Integer.parseInt(specificExpirationDelay);
                }
                if ((classifieds = this.classifiedService.getAllClassifiedsToUnpublish(expirationDelay, string2)) == null) continue;
                for (ClassifiedDetail classified : classifieds) {
                    this.classifiedService.unpublishClassified(classified.getIdentifier());
                }
            }
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(e.getMessage(), e);
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doScheduledDeleteClassifieds();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
    }
}

