/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.blog.BlogContentManager;
import org.silverpeas.components.blog.dao.PostDAO;
import org.silverpeas.components.blog.model.Archive;
import org.silverpeas.components.blog.model.BlogRuntimeException;
import org.silverpeas.components.blog.model.Category;
import org.silverpeas.components.blog.model.PostDetail;
import org.silverpeas.components.blog.notification.BlogUserSubscriptionNotification;
import org.silverpeas.components.blog.service.BlogService;
import org.silverpeas.core.NotFoundException;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.html.PermalinkRegistry;
import org.silverpeas.core.index.search.SearchEngineProvider;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodeOrderComparator;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionService;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.service.ComponentSubscription;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
@Named(value="blogService")
public class DefaultBlogService
implements BlogService,
Initialization {
    private static final String MESSAGES_PATH = "org.silverpeas.blog.multilang.blogBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.blog.settings.blogSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.blog.settings.blogSettings");
    private static final String POST = "post";
    private static final String USELESS = "useless";
    @Inject
    private CommentService commentService;
    @Inject
    private PdcManager pdcManager;
    @Inject
    private PdcSubscriptionManager pdcSubscriptionManager;
    @Inject
    private BlogContentManager blogContentManager;
    @Inject
    private NodeService nodeService;
    @Inject
    private PublicationService publicationService;

    public void init() {
        PermalinkRegistry.get().addUrlPart("Post");
    }

    @Override
    public Optional<PostDetail> getContributionById(ContributionIdentifier contributionId) {
        PublicationDetail publication = this.publicationService.getDetail(new PublicationPK(contributionId.getLocalId(), contributionId.getComponentInstanceId()));
        return publication == null ? Optional.empty() : Optional.of(this.getPost(publication));
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("blog");
    }

    @Override
    public Date getDateEvent(String pubId) {
        Date date;
        block8: {
            Connection con = this.openConnection();
            try {
                date = PostDAO.getDateEvent(con, pubId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)POST, (Object)pubId), e);
                }
            }
            con.close();
        }
        return date;
    }

    @Override
    @Transactional
    public String createPost(PostDetail post) {
        return this.createPost(post, null);
    }

    @Override
    @Transactional
    public String createPost(PostDetail post, PdcClassification classification) {
        String string;
        block10: {
            Connection con = this.openConnection();
            try {
                PublicationDetail pub = post.getPublication();
                pub.setStatus("Draft");
                PublicationPK pk = this.publicationService.createPublication(pub);
                PostDAO.createDateEvent(con, pk.getId(), post.getDateEvent(), pk.getInstanceId());
                if (StringUtil.isDefined((String)post.getCategoryId())) {
                    this.setCategory(pk, post.getCategoryId());
                }
                WysiwygController.createUnindexedFileAndAttachment((String)"", (ResourceReference)new ResourceReference((WAPrimaryKey)pk), (String)pub.getCreatorId(), (String)pub.getLanguage());
                this.createSilverContent(con, pub, pub.getCreatorId());
                if (classification != null) {
                    classification.classifyContent((Contribution)pub);
                }
                string = pk.getId();
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnAdding((String)POST, (Object)post.getId()), e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public void sendSubscriptionsNotification(NodePK fatherPK, PostDetail post, Comment comment, String type, String senderId) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new BlogUserSubscriptionNotification(post, comment, type, senderId));
        try {
            PublicationPK pubPK = post.getPublication().getPK();
            int silverObjectId = this.getSilverObjectId(pubPK);
            List positions = this.pdcManager.getPositions(silverObjectId, pubPK.getInstanceId());
            if (positions != null) {
                for (ClassifyPosition position : positions) {
                    this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), pubPK.getInstanceId(), silverObjectId);
                }
            }
        }
        catch (PdcException e) {
            SilverLogger.getLogger((Object)this).error("PdC subscriber notification failure", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void updatePost(PostDetail post, PdcClassification classification) {
        try (Connection con = this.openConnection();){
            PublicationPK pubPk = post.getPublication().getPK();
            PublicationDetail pub = post.getPublication();
            this.publicationService.removeAllFathers(pubPk);
            this.publicationService.setDetail(pub);
            if (StringUtil.isDefined((String)post.getCategoryId())) {
                this.setCategory(pubPk, post.getCategoryId());
            }
            PostDAO.updateDateEvent(con, pubPk.getId(), post.getDateEvent());
            WysiwygController.updateFileAndAttachment((String)post.getContent(), (String)pub.getInstanceId(), (String)pubPk.getId(), (String)pub.getUpdaterId(), (String)pub.getLanguage(), (boolean)false);
            if (classification != null) {
                classification.classifyContentOrClearClassificationIfEmpty((Contribution)pub, false);
            }
            if (pub.isValid()) {
                this.sendSubscriptionsNotification(new NodePK("0", pub.getPK().getSpaceId(), pub.getPK().getInstanceId()), post, null, "update", pub.getUpdaterId());
            }
        }
        catch (SQLException e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnUpdate((String)POST, (Object)post.getId()), e);
        }
    }

    private void setCategory(PublicationPK pk, String categoryId) {
        NodePK nodePK = new NodePK(categoryId, pk.getInstanceId());
        this.publicationService.addFather(pk, nodePK);
    }

    @Override
    @Transactional
    public void deletePost(String postId, String instanceId) {
        try (Connection con = this.openConnection();){
            PublicationPK pubPK = new PublicationPK(postId, instanceId);
            this.publicationService.removeAllFathers(pubPK);
            PostDAO.deleteDateEvent(con, pubPK.getId());
            ResourceReference resourceReference = new ResourceReference(postId, instanceId);
            this.getCommentService().deleteAllCommentsOnResource(PostDetail.getResourceType(), resourceReference);
            WysiwygController.deleteFileAndAttachment((String)instanceId, (String)postId);
            this.publicationService.removePublication(pubPK);
            this.blogContentManager.deleteSilverContent(con, pubPK);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)POST, (Object)postId), e);
        }
    }

    private Connection openConnection() {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnOpeningConnectionTo((String)"datasource"), e);
        }
        return con;
    }

    @Nonnull
    private PostDetail getPost(PublicationDetail publication) {
        try {
            Date dateEvent;
            List allCat = this.publicationService.getAllFatherPKInSamePublicationComponentInstance(publication.getPK());
            Category cat = null;
            if (!allCat.isEmpty()) {
                Iterator it = allCat.iterator();
                NodePK nodePK = (NodePK)it.next();
                cat = this.getCategory(nodePK);
            }
            ResourceReference ref = new ResourceReference((WAPrimaryKey)publication.getPK());
            List comments = this.getCommentService().getAllCommentsOnResource(PostDetail.getResourceType(), ref);
            try (Connection con = this.openConnection();){
                dateEvent = PostDAO.getDateEvent(con, publication.getPK().getId());
            }
            PostDetail post = new PostDetail(publication, cat, comments.size(), dateEvent);
            post.setCreatorName(publication.getCreator().getDisplayedName());
            return post;
        }
        catch (Exception e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"post associated to publication", (Object)publication.getId()), e);
        }
    }

    @Override
    public Collection<PostDetail> getAllPosts(String instanceId) {
        ArrayList<PostDetail> arrayList;
        block10: {
            ArrayList<PostDetail> posts = new ArrayList<PostDetail>();
            Connection con = this.openConnection();
            try {
                Collection<String> lastEvents = PostDAO.getAllEvents(con, instanceId);
                Collection publications = this.publicationService.getAllPublications(instanceId);
                for (String pubId : lastEvents) {
                    for (PublicationDetail publication : publications) {
                        if (!publication.getPK().getId().equals(pubId)) continue;
                        posts.add(this.getPost(publication));
                    }
                }
                arrayList = posts;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts of blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<PostDetail> getAllValidPosts(String instanceId, int nbReturned) {
        ArrayList<PostDetail> arrayList;
        block10: {
            ArrayList<PostDetail> posts = new ArrayList<PostDetail>();
            int count = nbReturned;
            Connection con = this.openConnection();
            try {
                Collection<String> lastEvents = PostDAO.getAllEvents(con, instanceId);
                Collection publications = this.publicationService.getAllPublications(instanceId);
                for (String pubId : lastEvents) {
                    for (PublicationDetail publication : publications) {
                        if (!publication.getPK().getId().equals(pubId) || !"Valid".equals(publication.getStatus()) || count <= 0) continue;
                        --count;
                        posts.add(this.getPost(publication));
                    }
                }
                arrayList = posts;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"All validated posts for blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<PostDetail> getPostsByCategory(String categoryId, String instanceId) {
        ArrayList<PostDetail> arrayList;
        block10: {
            NodePK pk = new NodePK(categoryId, null, instanceId);
            ArrayList<PostDetail> posts = new ArrayList<PostDetail>();
            Connection con = this.openConnection();
            try {
                Collection<String> lastEvents = PostDAO.getAllEvents(con, instanceId);
                Collection publications = this.publicationService.getPubPKsInFatherPK(pk);
                PublicationPK[] allPubs = publications.toArray(new PublicationPK[0]);
                for (String pubId : lastEvents) {
                    for (int i = 0; i < allPubs.length; ++i) {
                        int j = allPubs.length - i - 1;
                        PublicationPK pubPK = allPubs[j];
                        if (!pubPK.getId().equals(pubId)) continue;
                        ContributionIdentifier postId = ContributionIdentifier.from((String)instanceId, (String)pubId, (String)PostDetail.getResourceType());
                        posts.add(this.getContributionById(postId).orElse(null));
                    }
                }
                arrayList = posts;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts in category", (Object)categoryId), e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<PostDetail> getPostsByDate(String date, String instanceId) {
        return this.getPostsByArchive(date, date, instanceId);
    }

    @Override
    public Collection<PostDetail> getPostsByArchive(String beginDate, String endDate, String instanceId) {
        ArrayList<PostDetail> arrayList;
        block10: {
            ArrayList<PostDetail> posts = new ArrayList<PostDetail>();
            Connection con = this.openConnection();
            try {
                Collection<String> lastEvents = PostDAO.getEventsByDates(con, instanceId, beginDate, endDate);
                Collection publications = this.publicationService.getAllPublications(instanceId);
                for (String pubId : lastEvents) {
                    for (PublicationDetail publication : publications) {
                        if (!publication.getPK().getId().equals(pubId)) continue;
                        posts.add(this.getPost(publication));
                    }
                }
                arrayList = posts;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all posts archived between", (Object)(beginDate + " and " + endDate)), e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<PostDetail> getResultSearch(String word, String userId, String instanceId) {
        ArrayList<PostDetail> posts = new ArrayList<PostDetail>();
        ArrayList<String> postIds = new ArrayList<String>();
        QueryDescription query = new QueryDescription(word);
        query.setSearchingUser(userId);
        query.addComponent(instanceId);
        try (Connection con = this.openConnection();){
            List result = SearchEngineProvider.getSearchEngine().search(query).getEntries();
            Collection<String> allEvents = PostDAO.getAllEvents(con, instanceId);
            for (String pubId : allEvents) {
                for (MatchingIndexEntry matchIndex : result) {
                    String objectId = matchIndex.getObjectId();
                    if (!pubId.equals(objectId) || postIds.contains(objectId)) continue;
                    ContributionIdentifier postId = ContributionIdentifier.from((String)instanceId, (String)pubId, (String)PostDetail.getResourceType());
                    PostDetail post = this.getContributionById(postId).orElseThrow(() -> new NotFoundException("No such post " + objectId));
                    postIds.add(objectId);
                    posts.add(post);
                }
            }
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
        return posts;
    }

    @Override
    @Transactional
    public void createCategory(Category category) {
        try {
            this.nodeService.createNode((NodeDetail)category, new NodeDetail());
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void updateCategory(Category category) {
        try {
            this.nodeService.setDetail((NodeDetail)category);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteCategory(String id, String instanceId) {
        try {
            NodePK nodePk = new NodePK(id, instanceId);
            Collection<PostDetail> posts = this.getPostsByCategory(id, instanceId);
            for (PostDetail post : posts) {
                this.publicationService.removeFather(post.getPublication().getPK(), nodePk);
            }
            this.nodeService.removeNode(nodePk);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    public Category getCategory(NodePK pk) {
        return new Category(this.nodeService.getDetail(pk));
    }

    @Override
    public Collection<NodeDetail> getAllCategories(String instanceId) {
        NodePK nodePK = new NodePK("0", instanceId);
        ArrayList<NodeDetail> result = new ArrayList<NodeDetail>(this.nodeService.getChildrenDetails(nodePK));
        result.sort((Comparator<NodeDetail>)new NodeOrderComparator());
        return result;
    }

    @Override
    public Collection<Archive> getAllArchives(String instanceId) {
        ArrayList<Archive> arrayList;
        block9: {
            Connection con = this.openConnection();
            try {
                ArrayList<Archive> archives = new ArrayList<Archive>();
                Calendar calendar = Calendar.getInstance(Locale.FRENCH);
                Collection<Date> lastEvents = PostDAO.getAllDateEvents(con, instanceId);
                for (Date dateEvent : lastEvents) {
                    calendar.setTime(dateEvent);
                    Archive archive = this.createArchive(calendar);
                    if (archives.contains(archive)) continue;
                    archives.add(archive);
                }
                arrayList = archives;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"All archives of blog", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    private Archive createArchive(Calendar calendar) {
        Date beginDate = this.getMonthFirstDay(calendar);
        Date endDate = this.getMonthLastDay(calendar);
        Archive archive = new Archive(USELESS, DateUtil.date2SQLDate((Date)beginDate), DateUtil.date2SQLDate((Date)endDate));
        archive.setYear(Integer.toString(calendar.get(1)));
        archive.setMonthId(Integer.toString(calendar.get(2)));
        return archive;
    }

    @Override
    public void indexBlog(String componentId) {
        this.indexTopics(new NodePK(USELESS, componentId));
        this.indexPublications(componentId);
    }

    private void indexPublications(String componentId) {
        Collection pubs;
        try {
            pubs = this.publicationService.getAllPublications(componentId);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"[INDEXING] all publications in blog", (Object)componentId), e);
        }
        if (pubs != null) {
            for (PublicationDetail pub : pubs) {
                try {
                    this.indexPublication(pub.getPK());
                }
                catch (Exception e) {
                    throw new BlogRuntimeException(SilverpeasExceptionMessages.failureOnIndexing((String)"publication", (Object)pub.getPK().toString()), e);
                }
            }
        }
    }

    private void indexPublication(PublicationPK pubPK) {
        this.publicationService.createIndex(pubPK);
        this.indexExternalElementsOfPublication(pubPK);
    }

    private void indexTopics(NodePK nodePK) {
        Collection nodes = this.nodeService.getAllNodes(nodePK);
        if (nodes != null) {
            for (NodeDetail node : nodes) {
                if (node.getNodePK().isRoot() || node.getNodePK().isTrash()) continue;
                this.nodeService.createIndex(node);
            }
        }
    }

    @Override
    public boolean isSubscribed(String userId, String instanceId) {
        return this.getSubscribeService().existsSubscription((Subscription)new ComponentSubscription(userId, instanceId));
    }

    private void indexExternalElementsOfPublication(PublicationPK pubPK) {
        try {
            this.getCommentService().indexAllCommentsOnPublication(PostDetail.getResourceType(), new ResourceReference((WAPrimaryKey)pubPK));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Comment index failure for publication {0}", (Object[])new String[]{pubPK.toString()}, (Throwable)e);
        }
    }

    private Date getMonthFirstDay(Calendar calendar) {
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date getMonthLastDay(Calendar calendar) {
        int monthLastDay = calendar.getActualMaximum(5);
        calendar.set(5, monthLastDay);
        return calendar.getTime();
    }

    private void createSilverContent(Connection con, PublicationDetail pubDetail, String creatorId) {
        try {
            this.blogContentManager.createSilverContent(con, (Contribution)pubDetail, creatorId);
        }
        catch (ContentManagerException e) {
            throw new BlogRuntimeException(e);
        }
    }

    private void updateSilverContentVisibility(PublicationDetail pubDetail) {
        try {
            this.blogContentManager.updateSilverContentVisibility((Contribution)pubDetail);
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
    }

    @Override
    public void draftOutPost(PostDetail post) {
        PublicationDetail pub = post.getPublication();
        pub.setStatus("Valid");
        this.publicationService.setDetail(pub);
        if (pub.getStatus().equals("Valid")) {
            this.updateSilverContentVisibility(pub);
            this.sendSubscriptionsNotification(new NodePK("0", pub.getPK().getSpaceId(), pub.getPK().getInstanceId()), post, null, "create", pub.getUpdaterId());
        }
    }

    private int createSilverContent(PublicationDetail pubDetail, String creatorId) {
        Connection con = null;
        try {
            con = this.openConnection();
            int n = this.blogContentManager.createSilverContent(con, (Contribution)pubDetail, creatorId);
            return n;
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private int getSilverObjectId(PublicationPK pubPK) {
        int silverObjectId;
        try {
            silverObjectId = this.blogContentManager.getSilverContentId(pubPK.getId(), pubPK.getInstanceId());
            if (silverObjectId == -1) {
                PublicationDetail pubDetail = this.publicationService.getDetail(pubPK);
                silverObjectId = this.createSilverContent(pubDetail, pubDetail.getCreatorId());
            }
        }
        catch (Exception e) {
            throw new BlogRuntimeException(e);
        }
        return silverObjectId;
    }

    private SubscriptionService getSubscribeService() {
        return SubscriptionServiceProvider.getSubscribeService();
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }
}

