/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.service;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.model.Reservation;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.model.ResourceValidator;
import org.silverpeas.components.resourcesmanager.repository.ReservationRepository;
import org.silverpeas.components.resourcesmanager.repository.ReservedResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceValidatorRepository;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;

@Service
@Transactional
public class ResourceService {
    @Inject
    ResourceRepository repository;
    @Inject
    ReservationRepository reservationRepository;
    @Inject
    private ReservedResourceRepository reservedResourceRepository;
    @Inject
    private ResourceValidatorRepository resourceValidatorRepository;

    public void createResource(Resource resource) {
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public void updateResource(Resource resource) {
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public List<Resource> getResources() {
        return this.repository.getAll();
    }

    public Resource getResource(long id) {
        return (Resource)this.repository.getById(Long.toString(id));
    }

    public void deleteResource(long id) {
        this.reservedResourceRepository.deleteAllReservedResourcesForResource(id);
        this.repository.deleteById(new String[]{Long.toString(id)});
    }

    public void deleteResourcesFromCategory(Long categoryId) {
        this.repository.deleteResourcesFromCategory(categoryId);
    }

    public void addManagers(long resourceId, List<ResourceValidator> managerIds) {
        Resource resource = (Resource)this.repository.getById(Long.toString(resourceId));
        for (ResourceValidator manager : managerIds) {
            manager.setResource(resource);
            resource.getManagers().add(manager);
        }
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public void addManager(ResourceValidator manager) {
        Resource resource = (Resource)this.repository.getById(Long.toString(manager.getResourceId()));
        resource.getManagers().add(manager);
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public List<ResourceValidator> getManagers(long resourceId) {
        Resource resource = (Resource)this.repository.getById(Long.toString(resourceId));
        return new ArrayList<ResourceValidator>(resource.getManagers());
    }

    public void removeAllManagers(long resourceId) {
        Resource resource = (Resource)this.repository.getById(Long.toString(resourceId));
        resource.getManagers().clear();
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public void removeManager(ResourceValidator manager) {
        Resource resource = (Resource)this.repository.getById(Long.toString(manager.getResourceId()));
        resource.getManagers().remove(manager);
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public List<Resource> getResourcesByCategory(Long categoryId) {
        return this.repository.findAllResourcesByCategory(categoryId);
    }

    public List<Resource> listAvailableResources(String instanceId, String startDate, String endDate) {
        List<Resource> bookableResources = this.repository.findAllBookableResources(instanceId);
        ArrayList<Resource> availableBookableResources = new ArrayList<Resource>(bookableResources.size());
        for (Resource resource : bookableResources) {
            List<Reservation> reservations = this.reservationRepository.findAllReservationsNotRefusedForResourceInRange(resource.getIdAsLong(), startDate, endDate);
            if (reservations != null && !reservations.isEmpty()) continue;
            availableBookableResources.add(resource);
        }
        return availableBookableResources;
    }

    public boolean isManager(Long userId, Long resourceId) {
        return this.resourceValidatorRepository.getResourceValidator(resourceId, userId) != null;
    }

    public List<Resource> listResourcesOfReservation(Long reservationId) {
        return this.repository.findAllResourcesForReservation(reservationId);
    }

    public List<Resource> findAllReservedResources(long reservationIdToSkip, List<Long> aimedResourceIds, String startPeriod, String endPeriod) {
        return this.repository.findAllReservedResources(reservationIdToSkip, aimedResourceIds, startPeriod, endPeriod);
    }
}

