/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter.notification;

import java.util.Collection;
import org.silverpeas.components.infoletter.model.InfoLetterPublicationPdC;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;

public class InfoLetterSubscriptionPublicationUserNotification
extends AbstractTemplateUserNotificationBuilder<InfoLetterPublicationPdC>
implements UserSubscriptionNotificationBehavior {
    private final User sender;
    private final SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;

    public InfoLetterSubscriptionPublicationUserNotification(InfoLetterPublicationPdC resource, User sender) {
        super((Object)resource);
        this.sender = sender;
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponent((String)this.getComponentInstanceId()).indexBySubscriberType();
    }

    protected boolean isUserCanBeNotified(String userId) {
        return true;
    }

    protected boolean isGroupCanBeNotified(String groupId) {
        return true;
    }

    protected void performTemplateData(String language, InfoLetterPublicationPdC resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("infoLetter", this.getResource());
        template.setAttribute("infoLetterTitle", (Object)((InfoLetterPublicationPdC)this.getResource()).getName(language));
        String desc = StringUtil.defaultStringIfNotDefined((String)((InfoLetterPublicationPdC)this.getResource()).getDescription(language), null);
        template.setAttribute("infoLetterDesc", (Object)desc);
        template.setAttribute("senderName", (Object)this.sender.getDisplayedName());
    }

    protected void performNotificationResource(String language, InfoLetterPublicationPdC resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    protected void perform(InfoLetterPublicationPdC resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getResourceURL(InfoLetterPublicationPdC resource) {
        return "/RinfoLetter/" + this.getComponentInstanceId() + "/View?parution=" + ((InfoLetterPublicationPdC)this.getResource()).getPK().getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.infoLetter.multilang.infoLetterBundle";
    }

    protected String getBundleSubjectKey() {
        return "infoLetter.emailSubject";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "infoLetter.notifLinkLabel";
    }

    protected String getTitle(String language) {
        return super.getTitle(language) + ((InfoLetterPublicationPdC)this.getResource()).getName(language);
    }

    protected String getTemplateFileName() {
        return "infoLetterNotification";
    }

    protected String getTemplatePath() {
        return "infoLetter";
    }

    protected NotifAction getAction() {
        return NotifAction.PUBLISHED;
    }

    protected String getComponentInstanceId() {
        return ((InfoLetterPublicationPdC)this.getResource()).getComponentInstanceId();
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }

    protected boolean isSendImmediately() {
        return true;
    }
}

