/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.whitepages.service.WhitePageServiceProvider;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Named
public class WhitePagesInstancePreDestruction
implements ComponentInstancePreDestruction {
    private static final String WHITE_CARDS_DELETION = "DELETE FROM SC_WhitePages_Card WHERE instanceId = ?";

    @Transactional
    public void preDestroy(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement deletion = connection.prepareStatement(WHITE_CARDS_DELETION);){
            deletion.setString(1, componentInstanceId);
            deletion.execute();
            PublicationTemplateManager.getInstance().removePublicationTemplate(componentInstanceId);
            WhitePageServiceProvider.getWhitePagesService().deleteFields(componentInstanceId);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

