/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.gallery.model.MediaOrderCriteriaProcessor;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;

public class MediaOrderCriteria {
    private String componentInstanceId;
    private final List<String> identifiers = new ArrayList<String>();
    private String ordererId;
    private Date referenceDate = DateUtil.getDate();
    private Integer nbDaysAfterThatDeleteAnOrder;

    private MediaOrderCriteria() {
    }

    public static MediaOrderCriteria fromComponentInstanceId(String componentInstanceId) {
        MediaOrderCriteria criteria = new MediaOrderCriteria();
        criteria.componentInstanceId = componentInstanceId;
        return criteria;
    }

    public static MediaOrderCriteria fromNbDaysAfterThatDeleteAnOrder(int nbDays) {
        MediaOrderCriteria criteria = new MediaOrderCriteria();
        criteria.nbDaysAfterThatDeleteAnOrder = nbDays;
        return criteria;
    }

    public MediaOrderCriteria withOrdererId(String ordererId) {
        this.ordererId = ordererId;
        return this;
    }

    public MediaOrderCriteria identifierIsOneOf(String ... identifiers) {
        CollectionUtil.addAllIgnoreNull(this.identifiers, (Object[])identifiers);
        return this;
    }

    public MediaOrderCriteria referenceDateOf(Date referenceDate) {
        if (referenceDate == null) {
            throw new IllegalArgumentException("dateReference parameter must not be null");
        }
        this.referenceDate = referenceDate;
        return this;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    private String getOrdererId() {
        return this.ordererId;
    }

    private List<String> getIdentifiers() {
        return this.identifiers;
    }

    private Date getReferenceDate() {
        return this.referenceDate;
    }

    private Integer getNbDaysAfterThatDeleteAnOrder() {
        return this.nbDaysAfterThatDeleteAnOrder;
    }

    public void processWith(MediaOrderCriteriaProcessor processor) {
        processor.startProcessing();
        if (StringUtil.isDefined((String)this.getComponentInstanceId())) {
            processor.processComponentInstance(this.getComponentInstanceId());
        }
        if (!this.getIdentifiers().isEmpty()) {
            processor.then().processIdentifiers(this.getIdentifiers());
        }
        if (JdbcSqlQuery.isSqlDefined((String)this.getOrdererId())) {
            processor.then().processOrderer(this.getOrdererId());
        }
        if (this.getNbDaysAfterThatDeleteAnOrder() != null) {
            processor.then().processNbDaysAfterThatDeleteAnOrder(this.getReferenceDate(), this.getNbDaysAfterThatDeleteAnOrder());
        }
        processor.endProcessing();
    }
}

