/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.token;

import java.lang.annotation.Annotation;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.date.TemporalFormatter;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.TokenGenerationParameter;
import org.silverpeas.core.security.token.TokenGenerator;
import org.silverpeas.core.security.token.TokenGeneratorProvider;
import org.silverpeas.core.security.token.exception.TokenValidationException;
import org.silverpeas.core.security.token.synchronizer.SynchronizerToken;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.util.security.SecuritySettings;

@Service
public class SynchronizerTokenService {
    public static final String SESSION_TOKEN_KEY = "X-STKN";
    public static final String NAVIGATION_TOKEN_KEY = "X-NTKN";
    private static final String UNPROTECTED_URI_RULE = "(?i)(?!.*(/qaptcha|rpdcsearch/|rclipboard/|rselectionpeaswrapper/|rusernotification/|services/usernotifications/|blockingNews|services/password/)).*";
    private static final String DEFAULT_GET_RULE_KEYWORDS = "(delete|update|creat|save|block)";
    private static final String DEFAULT_GET_RULE_ON_KEYWORD = "(?i)^.*(delete|update|creat|save|block).*$";
    private static final String DEFAULT_GET_RULE = "(?i)^/\\w+[\\w/]*/jsp/.*(delete|update|creat|save|block).*$";
    private static final SilverLogger logger = SilverLogger.getLogger((String)"silverpeas.core.security");
    private static final List<String> DEFAULT_PROTECTED_METHODS = Arrays.asList("POST", "PUT", "DELETE");

    public static SynchronizerTokenService getInstance() {
        return (SynchronizerTokenService)ServiceProvider.getService(SynchronizerTokenService.class, (Annotation[])new Annotation[0]);
    }

    protected SynchronizerTokenService() {
    }

    public void setUpSessionTokens(SessionInfo session) {
        if (SecuritySettings.isWebSecurityByTokensEnabled()) {
            User user = session.getUserDetail() != null ? session.getUserDetail() : User.getCurrentRequester();
            Token token = (Token)session.getAttribute(SESSION_TOKEN_KEY);
            TokenGenerator generator = TokenGeneratorProvider.getTokenGenerator(SynchronizerToken.class);
            if (token != null) {
                logger.debug("Renew the session token for the user {0} ({1})", new Object[]{user.getId(), user.getDisplayedName()});
                token = generator.renew(token);
            } else {
                logger.debug("Create the session token for the user {0} ({1})", new Object[]{user.getId(), user.getDisplayedName()});
                token = generator.generate(new TokenGenerationParameter[0]);
            }
            session.setAttribute(SESSION_TOKEN_KEY, (Object)token);
        }
    }

    public void setUpNavigationTokens(HttpServletRequest request) {
        if (SecuritySettings.isWebSecurityByTokensEnabled()) {
            logger.debug("Create a navigation token for path {0}", new Object[]{this.getRequestPath(request)});
            HttpSession session = request.getSession();
            TokenGenerator generator = TokenGeneratorProvider.getTokenGenerator(SynchronizerToken.class);
            Token token = generator.generate(new TokenGenerationParameter[0]);
            session.setAttribute(NAVIGATION_TOKEN_KEY, (Object)token);
        }
    }

    public void validate(HttpServletRequest request, boolean onKeywordsOnly) throws TokenValidationException {
        if (SecuritySettings.isWebSecurityByTokensEnabled() && this.isAProtectedResource(request, onKeywordsOnly)) {
            String actualToken;
            logger.debug("Validate the request for path {0}", new Object[]{this.getRequestPath(request)});
            Token expectedToken = this.getSessionToken(request);
            if (expectedToken.isDefined()) {
                actualToken = this.getTokenInRequest(SESSION_TOKEN_KEY, request);
                this.validate(request, actualToken, expectedToken);
            }
            if ((expectedToken = this.getTokenInSession(NAVIGATION_TOKEN_KEY, request, true)).isDefined()) {
                logger.debug("Validate the request origin for path {0}", new Object[]{this.getRequestPath(request)});
                actualToken = this.getTokenInRequest(NAVIGATION_TOKEN_KEY, request);
                this.validate(request, actualToken, expectedToken);
            }
        }
    }

    public boolean isAProtectedResource(HttpServletRequest request, boolean onKeywordsOnly) {
        boolean isProtected = false;
        if (request.getRequestURI().matches(UNPROTECTED_URI_RULE) && !(isProtected = DEFAULT_PROTECTED_METHODS.contains(request.getMethod())) && "GET".equals(request.getMethod())) {
            String path = this.getRequestPath(request);
            isProtected = onKeywordsOnly ? path.matches(DEFAULT_GET_RULE_ON_KEYWORD) : path.matches(DEFAULT_GET_RULE);
        }
        return isProtected;
    }

    public Token getSessionToken(HttpServletRequest request) {
        return this.getTokenInSession(SESSION_TOKEN_KEY, request, false);
    }

    public Token getSessionToken(SessionInfo session) {
        Token token = (Token)session.getAttribute(SESSION_TOKEN_KEY);
        return token == null ? SynchronizerToken.NoneToken : token;
    }

    public Token getNavigationToken(HttpServletRequest request) {
        return this.getTokenInSession(NAVIGATION_TOKEN_KEY, request, false);
    }

    private String getRequestPath(HttpServletRequest request) {
        String path = request.getRequestURI();
        if (path.startsWith(request.getContextPath())) {
            path = path.substring(request.getContextPath().length());
        }
        return path;
    }

    private void validate(HttpServletRequest request, String actualToken, Token expectedToken) throws TokenValidationException {
        if (!(StringUtil.isDefined((String)actualToken) && expectedToken.isDefined() && expectedToken.getValue().equals(actualToken))) {
            this.throwTokenInvalidException(request);
        }
    }

    private void throwTokenInvalidException(HttpServletRequest request) throws TokenValidationException {
        String now = TemporalFormatter.toBaseIso8601((Temporal)OffsetDateTime.now(), (boolean)true);
        TokenValidationException exception = new TokenValidationException("Attempt of a CSRF attack detected at " + now);
        logger.error("The request for path {0} isn''t valid: {1}", new Object[]{request.getRequestURI(), exception.getMessage()});
        throw exception;
    }

    private Token getTokenInSession(String tokenId, HttpServletRequest request, boolean pop) {
        SessionManagement sessionManagement;
        SessionInfo sessionInfo;
        String sessionId;
        Token token = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            token = this.getToken(tokenId, session, pop);
        }
        if (token == null && StringUtil.isDefined((String)(sessionId = request.getHeader("X-Silverpeas-Session"))) && (sessionInfo = (sessionManagement = SessionManagementProvider.getSessionManagement()).getSessionInfo(sessionId)).isDefined() && (token = (Token)sessionInfo.getAttribute(tokenId)) != null && pop) {
            sessionInfo.unsetAttribute(tokenId);
        }
        return token == null ? SynchronizerToken.NoneToken : token;
    }

    @Nullable
    private Token getToken(String tokenId, HttpSession session, boolean pop) {
        Token token = (Token)session.getAttribute(tokenId);
        if (token != null && pop) {
            session.removeAttribute(tokenId);
        }
        return token;
    }

    private String getTokenInRequest(String tokenId, HttpServletRequest request) {
        String token = request.getHeader(tokenId);
        if (StringUtil.isNotDefined((String)token) && StringUtil.isNotDefined((String)(token = request.getParameter(tokenId)))) {
            token = (String)request.getAttribute(tokenId);
        }
        return token;
    }
}

