/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.organizationchart.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.silverpeas.components.organizationchart.model.OrganizationalPerson;
import org.silverpeas.components.organizationchart.model.OrganizationalRole;
import org.silverpeas.components.organizationchart.model.PersonCategory;
import org.silverpeas.components.organizationchart.service.AbstractOrganizationChartConfiguration;
import org.silverpeas.core.util.StringUtil;

abstract class AbstractOrganizationChartBuilder {
    AbstractOrganizationChartBuilder() {
    }

    void defineUnitChartRoles(OrganizationalPerson person, String function, AbstractOrganizationChartConfiguration config) {
        boolean roleDefined = false;
        for (OrganizationalRole role : config.getUnitsChartRightLabel()) {
            if (!this.isFunctionMatchingRole(function, role)) continue;
            person.setVisibleOnRight(true);
            person.setVisibleRightRole(role);
            roleDefined = true;
            break;
        }
        if (!roleDefined) {
            for (OrganizationalRole role : config.getUnitsChartLeftLabel()) {
                if (!this.isFunctionMatchingRole(function, role)) continue;
                person.setVisibleOnLeft(true);
                person.setVisibleLeftRole(role);
                roleDefined = true;
                break;
            }
        }
        if (!roleDefined) {
            for (OrganizationalRole role : config.getUnitsChartCentralLabel()) {
                if (!this.isFunctionMatchingRole(function, role)) continue;
                person.setVisibleOnCenter(true);
                person.setVisibleCenterRole(role);
                break;
            }
        }
    }

    void defineDetailledChartRoles(OrganizationalPerson pers, String function, AbstractOrganizationChartConfiguration config) {
        boolean roleDefined = false;
        for (OrganizationalRole role : config.getPersonnsChartCentralLabel()) {
            if (!this.isFunctionMatchingRole(function, role)) continue;
            pers.setVisibleOnCenter(true);
            pers.setVisibleCenterRole(role);
            roleDefined = true;
            break;
        }
        if (!roleDefined) {
            int order = 0;
            for (OrganizationalRole role : config.getPersonnsChartCategoriesLabel()) {
                if (this.isFunctionMatchingRole(function, role)) {
                    pers.setVisibleCategory(new PersonCategory(role.getLabel(), role.getLdapKey(), order));
                    roleDefined = true;
                    break;
                }
                ++order;
            }
        }
        if (!roleDefined) {
            pers.setVisibleCategory(new PersonCategory("Personnel"));
        }
    }

    private boolean isFunctionMatchingRole(String function, OrganizationalRole role) {
        return role != null && StringUtil.isDefined((String)role.getLdapKey()) && function.toLowerCase().contains(role.getLdapKey().toLowerCase());
    }

    List<OrganizationalPerson> getMainActors(List<OrganizationalPerson> users) {
        ArrayList<OrganizationalPerson> mainActors = new ArrayList<OrganizationalPerson>();
        for (OrganizationalPerson person : users) {
            if (!person.isVisibleOnCenter()) continue;
            mainActors.add(person);
        }
        return mainActors;
    }

    Set<PersonCategory> getCategories(List<OrganizationalPerson> personList) {
        TreeSet<PersonCategory> categories = new TreeSet<PersonCategory>();
        for (OrganizationalPerson person : personList) {
            if (person.isVisibleOnCenter() || person.getVisibleCategory() == null) continue;
            categories.add(person.getVisibleCategory());
        }
        return categories;
    }
}

