/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.service;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.model.Category;
import org.silverpeas.components.resourcesmanager.model.Reservation;
import org.silverpeas.components.resourcesmanager.model.ReservedResource;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.model.ResourceValidator;
import org.silverpeas.components.resourcesmanager.service.CategoryService;
import org.silverpeas.components.resourcesmanager.service.ReservationService;
import org.silverpeas.components.resourcesmanager.service.ReservedResourceService;
import org.silverpeas.components.resourcesmanager.service.ResourceService;
import org.silverpeas.components.resourcesmanager.service.ResourcesManager;
import org.silverpeas.components.resourcesmanager.service.ResourcesManagerRuntimeException;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.StringUtil;

@Service
@Transactional
public class SimpleResourcesManager
implements ResourcesManager,
Serializable {
    private static final long serialVersionUID = -8053955818376554252L;
    @Inject
    private CategoryService categoryService;
    @Inject
    private ResourceService resourceService;
    @Inject
    private ReservationService reservationService;
    @Inject
    private ReservedResourceService reservedResourceService;

    @Override
    public void createCategory(Category category) {
        this.categoryService.createCategory(category);
        this.createCategoryIndex(category);
    }

    @Override
    public List<Category> getCategories(String instanceId) {
        return this.categoryService.getCategories(instanceId);
    }

    @Override
    public Category getCategory(Long id) {
        return this.categoryService.getCategory(id);
    }

    @Override
    public void updateCategory(Category category) {
        this.categoryService.updateCategory(category);
    }

    @Override
    public void deleteCategory(Long id, String componentId) {
        List<Resource> resources = this.getResourcesByCategory(id);
        for (Resource resource : resources) {
            this.resourceService.deleteResource(resource.getIdAsLong());
            this.deleteIndex(resource.getIdAsLong(), "Resource", componentId);
        }
        this.categoryService.deleteCategory(id);
        this.deleteIndex(id, "Category", componentId);
    }

    @Override
    public void createResource(Resource resource) {
        this.resourceService.createResource(resource);
        this.createResourceIndex(resource);
    }

    @Override
    public Resource getResource(Long id) {
        return this.resourceService.getResource(id);
    }

    @Override
    public List<Resource> getResourcesByCategory(Long categoryId) {
        return this.resourceService.getResourcesByCategory(categoryId);
    }

    @Override
    public void deleteResource(Long id, String componentId) {
        this.resourceService.deleteResource(id);
        this.deleteIndex(id, "Resource", componentId);
    }

    @Override
    public List<Resource> getResourcesReservable(String instanceId, Date startDate, Date endDate) {
        return this.resourceService.listAvailableResources(instanceId, String.valueOf(startDate.getTime()), String.valueOf(endDate.getTime()));
    }

    @Override
    public List<Resource> getResourcesOfReservation(String instanceId, Long reservationId) {
        return this.resourceService.listResourcesOfReservation(reservationId);
    }

    @Override
    public void updateReservation(Reservation reservation, List<Long> resourceIds, boolean updateDate) {
        List<ReservedResource> reservedResources = this.reservedResourceService.findAllReservedResourcesOfReservation(reservation.getIdAsLong());
        HashMap<Long, ReservedResource> oldReservedResources = new HashMap<Long, ReservedResource>(reservedResources.size());
        for (ReservedResource reservedResource : reservedResources) {
            oldReservedResources.put(reservedResource.getResourceId(), reservedResource);
        }
        boolean refused = false;
        boolean forValidation = false;
        String reservationStatus = "V";
        for (Long resourceId : resourceIds) {
            boolean isCreation;
            ReservedResource reservedResource = (ReservedResource)oldReservedResources.remove(resourceId);
            boolean bl = isCreation = reservedResource == null;
            if (isCreation || updateDate) {
                if (reservedResource == null) {
                    reservedResource = new ReservedResource();
                    reservedResource.setReservedResourceId(Long.toString(resourceId), reservation.getId());
                }
                if (this.resourceService.isManager(Long.parseLong(reservation.getUserId()), resourceId)) {
                    reservedResource.setStatus("V");
                } else if (this.resourceService.getManagers(resourceId).isEmpty()) {
                    reservedResource.setStatus("V");
                } else {
                    reservedResource.setStatus("A");
                }
                if (isCreation) {
                    this.reservedResourceService.create(reservedResource);
                } else {
                    reservedResource.setResource(null);
                    reservedResource.setReservation(null);
                    this.reservedResourceService.update(reservedResource);
                }
            }
            if (reservedResource.isValidationRequired()) {
                forValidation = true;
            }
            if (!reservedResource.isRefused()) continue;
            refused = true;
        }
        if (forValidation) {
            reservationStatus = "A";
        }
        if (refused) {
            reservationStatus = "R";
        }
        for (ReservedResource oldReservedResource : oldReservedResources.values()) {
            this.reservedResourceService.delete(oldReservedResource);
        }
        reservation.setStatus(reservationStatus);
        this.reservationService.updateReservation(reservation);
        this.createReservationIndex(reservation);
    }

    @Override
    public List<Resource> getReservedResources(String instanceId, List<Long> resources, Date startDate, Date endDate) {
        return this.getReservedResources(instanceId, resources, startDate, endDate, null);
    }

    @Override
    public List<Resource> getReservedResources(String instanceId, List<Long> aimedResourceIds, Date startDate, Date endDate, Long reservationIdToSkip) {
        String startPeriod = String.valueOf(startDate.getTime());
        String endPeriod = String.valueOf(endDate.getTime());
        return this.resourceService.findAllReservedResources(reservationIdToSkip != null ? reservationIdToSkip : -1L, aimedResourceIds, startPeriod, endPeriod);
    }

    @Override
    public List<Reservation> getReservations(String instanceId) {
        return this.reservationService.findAllReservations(instanceId);
    }

    @Override
    public List<Reservation> getUserReservations(String instanceId, String userId) {
        return this.reservationService.findAllReservations(instanceId);
    }

    @Override
    public Reservation getReservation(String instanceId, Long reservationId) {
        return this.reservationService.getReservation(reservationId);
    }

    @Override
    public void deleteReservation(Long id, String componentId) {
        this.deleteIndex(id, "Reservation", componentId);
        SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(new ResourceReference(id.toString(), componentId), null);
        for (SimpleDocument document : documents) {
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(document);
        }
        this.reservationService.deleteReservation(id);
    }

    @Override
    public List<Reservation> getReservationForValidation(String instanceId, String userId, Period period) {
        String[] searchPeriod = this.buildSearchPeriod(period);
        return this.reservationService.findAllReservationsForValidation(instanceId, Long.parseLong(userId), searchPeriod[0], searchPeriod[1]);
    }

    @Override
    public List<Reservation> getReservationOfUser(String instanceId, Integer userId, Period period) {
        String[] searchPeriod = this.buildSearchPeriod(period);
        return this.reservationService.findAllReservationsInRange(instanceId, userId, searchPeriod[0], searchPeriod[1]);
    }

    @Override
    public List<Reservation> getReservationWithResourcesOfCategory(String instanceId, Integer userId, Period period, Long categoryId) {
        String[] searchPeriod = this.buildSearchPeriod(period);
        return this.reservationService.findAllReservationsForCategoryInRange(instanceId, userId, categoryId, searchPeriod[0], searchPeriod[1]);
    }

    @Override
    public List<Reservation> getReservationWithResource(String instanceId, Integer userId, Period period, Long resourceId) {
        String[] searchPeriod = this.buildSearchPeriod(period);
        return this.reservationService.findAllReservationsForResourceInRange(instanceId, userId, resourceId, searchPeriod[0], searchPeriod[1]);
    }

    private String[] buildSearchPeriod(Period period) {
        return new String[]{String.valueOf(period.getBeginDate().getTime()), String.valueOf(period.getEndDate().getTime())};
    }

    @Override
    public String getResourceOfReservationStatus(Long resourceId, Long reservationId) {
        ReservedResource reserved = this.reservedResourceService.getReservedResource(resourceId, reservationId);
        return reserved.getStatus();
    }

    private void createCategoryIndex(Category category) {
        if (category != null) {
            FullIndexEntry indexEntry = new FullIndexEntry(category.getInstanceId(), "Category", category.getIdAsString());
            indexEntry.setTitle(category.getName());
            indexEntry.setPreview(category.getDescription());
            if (category.getUpdateDate() != null) {
                indexEntry.setCreationDate(category.getUpdateDate());
            } else {
                indexEntry.setCreationDate(category.getCreationDate());
            }
            indexEntry.setCreationUser(category.getCreaterId());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void createResourceIndex(Resource resource) {
        if (resource != null) {
            String xmlFormName;
            Category category;
            FullIndexEntry indexEntry = new FullIndexEntry(resource.getInstanceId(), "Resource", resource.getIdAsString());
            indexEntry.setTitle(resource.getName());
            indexEntry.setPreview(resource.getDescription());
            if (resource.getUpdateDate() != null) {
                indexEntry.setCreationDate(resource.getUpdateDate());
            } else {
                indexEntry.setCreationDate(resource.getCreationDate());
            }
            indexEntry.setCreationUser(resource.getCreaterId());
            Long categoryId = resource.getCategoryId();
            if (categoryId != null && (category = this.getCategory(categoryId)) != null && StringUtil.isDefined((String)(xmlFormName = category.getForm()))) {
                this.indexResourceForm(resource, indexEntry, xmlFormName);
            }
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void indexResourceForm(Resource resource, FullIndexEntry indexEntry, String xmlFormName) {
        String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
        try {
            PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(resource.getInstanceId() + ":" + xmlFormShortName);
            RecordSet set = pubTemplate.getRecordSet();
            set.indexRecord(String.valueOf(resource.getIdAsLong()), xmlFormName, indexEntry);
        }
        catch (Exception e) {
            throw new ResourcesManagerRuntimeException("ResourceManagerBmEJB.createIndex_Resource()", 4, "resourcesManager.EX_CREATE_INDEX_FAILED", e);
        }
    }

    private void createReservationIndex(Reservation reservation) {
        if (reservation != null) {
            FullIndexEntry indexEntry = new FullIndexEntry(reservation.getInstanceId(), "Reservation", reservation.getIdAsString());
            indexEntry.setTitle(reservation.getEvent());
            indexEntry.setPreview(reservation.getReason());
            indexEntry.setCreationDate(reservation.getCreationDate());
            indexEntry.setCreationUser(reservation.getUserId());
            indexEntry.setKeywords(reservation.getPlace());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(Long objectId, String objectType, String componentId) {
        if (objectId != null) {
            IndexEntryKey indexEntry = new IndexEntryKey(componentId, objectType, String.valueOf(objectId));
            IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
        }
    }

    @Override
    public void indexResourceManager(String instanceId) {
        List<Reservation> listOfReservation = this.getReservations(instanceId);
        if (listOfReservation != null) {
            for (Reservation reservation : listOfReservation) {
                try {
                    this.createReservationIndex(reservation);
                }
                catch (Exception e) {
                    throw new ResourcesManagerRuntimeException("ResourcesManagerBmEJB.indexResourceManager()", 4, "resourcesManager.MSG_INDEXRESERVATIONS", e);
                }
            }
        }
    }

    @Override
    public List<ResourceValidator> getManagers(long resourceId) {
        return this.resourceService.getManagers(resourceId);
    }

    @Override
    public void saveReservation(Reservation reservation, List<Long> resourceIds) {
        this.reservationService.createReservation(reservation, resourceIds);
        this.createReservationIndex(reservation);
    }

    @Override
    public void updateReservedResourceStatus(long reservationId, long resourceId, String status) {
        ReservedResource reservedResource = this.reservedResourceService.getReservedResource(resourceId, reservationId);
        if (reservedResource != null) {
            reservedResource.setStatus(status);
            this.reservedResourceService.update(reservedResource);
            Reservation reservation = reservedResource.getReservation();
            reservation.setStatus(this.reservationService.computeReservationStatus(reservation));
            this.reservationService.updateReservation(reservation);
        }
    }

    @Override
    public boolean isManager(long userId, long resourceId) {
        return this.resourceService.isManager(userId, resourceId);
    }

    @Override
    public void updateResource(Resource updatedResource, List<Long> managerIds) {
        Resource resource = this.getResource(updatedResource.getIdAsLong());
        resource.merge(updatedResource);
        resource.getManagers().clear();
        for (Long managerId : managerIds) {
            ResourceValidator validator = new ResourceValidator(resource.getIdAsLong(), managerId);
            if (resource.getManagers().contains(validator)) continue;
            resource.getManagers().add(validator);
        }
        this.resourceService.updateResource(resource);
        this.createResourceIndex(resource);
    }
}

