/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.notification;

import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.QuickInfoService;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.reminder.BackgroundReminderProcess;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.logging.SilverLogger;

@Named(value="quickinfoDelayedVisibilityUserNotificationReminderProcess")
@Singleton
public class QuickInfoDelayedVisibilityUserNotificationReminder
implements BackgroundReminderProcess {
    static final String PROCESS_NAME = "quickinfoDelayedVisibilityUserNotification";
    public static final ReminderProcessName QUICKINFO_DELAYED_VISIBILITY_USER_NOTIFICATION = () -> "quickinfoDelayedVisibilityUserNotification";
    @Inject
    private QuickInfoService newsService;

    public static QuickInfoDelayedVisibilityUserNotificationReminder get() {
        return (QuickInfoDelayedVisibilityUserNotificationReminder)ServiceProvider.getService(QuickInfoDelayedVisibilityUserNotificationReminder.class, (Annotation[])new Annotation[0]);
    }

    public ReminderProcessName getName() {
        return QUICKINFO_DELAYED_VISIBILITY_USER_NOTIFICATION;
    }

    public void performWith(Reminder reminder) {
        this.newsService.performReminder(reminder);
    }

    public boolean setAbout(News news) {
        ContributionIdentifier contributionId;
        Temporal delayedVisibilityTemporal = (Temporal)news.getModel().getProperty("DELAYED_VISIBILITY_AT", new Object[0]);
        if (delayedVisibilityTemporal != null && Reminder.getByContribution((ContributionIdentifier)(contributionId = news.getIdentifier())).stream().noneMatch(r -> QUICKINFO_DELAYED_VISIBILITY_USER_NOTIFICATION.asString().equals(r.getProcessName()))) {
            try {
                new DateTimeReminder(contributionId, QUICKINFO_DELAYED_VISIBILITY_USER_NOTIFICATION).triggerFrom("DELAYED_VISIBILITY_AT").schedule();
                return true;
            }
            catch (IllegalStateException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return false;
    }
}

