/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.form.fileitem.InternalFileItem;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.search.SearchEngineProvider;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.ParseException;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class PublicationImport {
    private KmeliaService kmeliaService;
    private String componentId;
    private String topicId;
    private String spaceId;
    private String userId;
    private boolean ignoreMissingFormFields = false;
    private SilverLogger logger = SilverLogger.getLogger((Object)this);

    public PublicationImport(KmeliaService kmeliaService, String componentId, String topicId, String spaceId, String userId) {
        this.kmeliaService = kmeliaService;
        this.componentId = componentId;
        this.topicId = topicId;
        this.spaceId = spaceId;
        this.userId = userId;
    }

    public PublicationImport(KmeliaService kmeliaService, String componentId) {
        this.kmeliaService = kmeliaService;
        this.componentId = componentId;
    }

    public void importPublications(List<Map<String, String>> publiParamsList, List<Map<String, String>> formParamsList, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        for (int i = 0; i < publiParamsList.size(); ++i) {
            this.importPublication(publiParamsList.get(i), formParamsList.get(i), language, xmlFormName, discrimatingParameterName, userProfile);
        }
    }

    public boolean importPublication(Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        String publicationToUpdateId = null;
        if (discrimatingParameterName != null && discrimatingParameterName.length() > 0) {
            String discrimatingParameterValue = formParams.get(discrimatingParameterName);
            publicationToUpdateId = this.getPublicationId(xmlFormName, discrimatingParameterName, discrimatingParameterValue);
        }
        return this.importPublication(publicationToUpdateId, publiParams, formParams, language, xmlFormName, userProfile);
    }

    public boolean importPublication(String publicationToUpdateId, Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String userProfile) {
        PublicationPK pubPK;
        boolean resultStatus;
        PublicationDetail pubDetail = null;
        if (publicationToUpdateId != null) {
            try {
                resultStatus = false;
                pubPK = new PublicationPK(publicationToUpdateId, this.spaceId, this.componentId);
                pubDetail = this.kmeliaService.getPublicationDetail(pubPK);
                this.updatePublicationDetail(pubDetail, publiParams, language);
                this.updatePublication(pubDetail, true);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException(e);
            }
        }
        try {
            resultStatus = true;
            pubDetail = this.getPublicationDetail(publiParams, language);
            this.createPublication(pubDetail);
            pubDetail.setInfoId(xmlFormName);
            this.updatePublication(pubDetail, true);
            pubPK = pubDetail.getPK();
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        try {
            String pubId = pubPK.getId();
            PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
            publicationTemplateManager.addDynamicPublicationTemplate(this.componentId + ":" + xmlFormName, xmlFormName + ".xml");
            PublicationTemplate pub = publicationTemplateManager.getPublicationTemplate(this.componentId + ":" + xmlFormName);
            RecordSet set = pub.getRecordSet();
            Form form = pub.getUpdateForm();
            DataRecord data = set.getRecord(pubId, language);
            if (data == null) {
                data = set.getEmptyRecord();
                data.setId(pubId);
                data.setLanguage(language);
            }
            PagesContext context = new PagesContext("myForm", "3", language, false, this.componentId, this.userId);
            context.setNodeId(this.topicId);
            context.setObjectId(pubId);
            context.setContentLanguage(language);
            if (this.ignoreMissingFormFields) {
                context.setUpdatePolicy(1);
            }
            ArrayList<InternalFileItem> items = new ArrayList<InternalFileItem>();
            for (String fieldName : data.getFieldNames()) {
                String fieldValue = formParams.get(fieldName);
                fieldValue = fieldValue == null ? "" : fieldValue;
                items.add(new InternalFileItem(fieldName, fieldValue));
            }
            form.update(items, data, context);
            set.save(data);
            this.updatePublication(pubDetail, true);
            NodePK nodePK = new NodePK(this.topicId, this.spaceId, this.componentId);
            this.kmeliaService.draftOutPublication(pubPK, nodePK, userProfile, true);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return resultStatus;
    }

    public List<XMLField> getPublicationXmlFields(String publicationId) {
        return this.getPublicationXmlFields(publicationId, null);
    }

    public List<XMLField> getPublicationXmlFields(String publicationId, String language) {
        PublicationPK pubPK = new PublicationPK(publicationId, this.spaceId, this.componentId);
        PublicationDetail pubDetail = this.kmeliaService.getPublicationDetail(pubPK);
        return pubDetail.getXmlFields(language);
    }

    private PublicationDetail getPublicationDetail(Map<String, String> parameters, String language) throws java.text.ParseException {
        String id = parameters.get("PubId");
        String status = parameters.get("Status");
        String name = parameters.get("Name");
        String description = parameters.get("Description");
        String keywords = parameters.get("Keywords");
        String beginDate = parameters.get("BeginDate");
        String endDate = parameters.get("EndDate");
        String version = parameters.get("Version");
        String importance = parameters.get("Importance");
        String beginHour = parameters.get("BeginHour");
        String endHour = parameters.get("EndHour");
        String author = parameters.get("Author");
        String validatorId = parameters.get("ValideurId");
        String tempId = parameters.get("TempId");
        String infoId = parameters.get("InfoId");
        String creationDate = parameters.get("CreationDate");
        String updateDate = parameters.get("UpdateDate");
        Date jBeginDate = null;
        Date jEndDate = null;
        if (StringUtil.isDefined((String)beginDate)) {
            jBeginDate = DateUtil.stringToDate((String)beginDate, (String)language);
        }
        if (StringUtil.isDefined((String)endDate)) {
            jEndDate = DateUtil.stringToDate((String)endDate, (String)language);
        }
        Date jCreationDate = StringUtil.isDefined((String)creationDate) ? DateUtil.stringToDate((String)creationDate, (String)language) : new Date();
        Date jUpdateDate = StringUtil.isDefined((String)updateDate) ? DateUtil.stringToDate((String)updateDate, (String)language) : jCreationDate;
        if (!StringUtil.isInteger((String)importance)) {
            importance = "5";
        }
        String pubId = StringUtil.isDefined((String)id) ? id : "";
        PublicationDetail pubDetail = PublicationDetail.builder((String)language).setPk(new PublicationPK(pubId, this.spaceId, this.componentId)).setNameAndDescription(name, description).created(jCreationDate, this.userId).updated(jUpdateDate, this.userId).setImportance(Integer.parseInt(importance)).setVersion(version).setKeywords(keywords).setContentPagePath("").setBeginDateTime(jBeginDate, beginHour).setEndDateTime(jEndDate, endHour).build();
        pubDetail.setAuthor(author);
        pubDetail.setStatus(status);
        if (StringUtil.isDefined((String)validatorId)) {
            pubDetail.setTargetValidatorId(validatorId);
        }
        pubDetail.setCloneId(tempId);
        if (StringUtil.isDefined((String)infoId)) {
            pubDetail.setInfoId(infoId);
        }
        return pubDetail;
    }

    private String createPublication(PublicationDetail pubDetail) {
        NodePK nodePK = new NodePK(this.topicId, this.spaceId, this.componentId);
        return this.kmeliaService.createPublicationIntoTopic(pubDetail, nodePK);
    }

    private void updatePublication(PublicationDetail pubDetail, boolean forceUpdateDate) {
        pubDetail.getPK().setSpace(this.spaceId);
        pubDetail.getPK().setComponentName(this.componentId);
        pubDetail.setUpdaterId(this.userId);
        pubDetail.setIndexOperation(-1);
        this.kmeliaService.updatePublication(pubDetail, forceUpdateDate);
    }

    public String getPublicationId(String xmlFormName, String fieldName, String fieldValue) {
        QueryDescription query = new QueryDescription("*");
        query.setSearchingUser(this.userId);
        query.addComponent(this.componentId);
        query.addFieldQuery(new FieldDescription(xmlFormName + "$$" + fieldName, fieldValue, null));
        try {
            List result = SearchEngineProvider.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry mie : result) {
                if (!"Publication".equals(mie.getObjectType())) continue;
                return mie.getPK().getObjectId();
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String createTopic(String name, String description) {
        NodeDetail topic = new NodeDetail("-1", name, description, 0, "X");
        topic.getNodePK().setSpace(this.spaceId);
        topic.getNodePK().setComponentName(this.componentId);
        topic.setCreatorId(this.userId);
        NodePK fatherPK = new NodePK(this.topicId, this.spaceId, this.componentId);
        String alertType = "None";
        NodePK nodePK = this.kmeliaService.addSubTopic(fatherPK, topic, alertType);
        return nodePK.getId();
    }

    public Collection<String> getPublicationsSpecificValues(String componentId, String xmlFormName, String fieldName) {
        PublicationService publicationService = this.getPublicationService();
        Collection publications = publicationService.getAllPublications(componentId);
        ArrayList<String> result = new ArrayList<String>();
        for (PublicationDetail publication : publications) {
            String fieldValue;
            NodePK fatherPK;
            List fatherPKs;
            if (!publication.getInfoId().equals(xmlFormName) || (fatherPKs = publicationService.getAllFatherPKInSamePublicationComponentInstance(publication.getPK())).isEmpty() || (fatherPK = (NodePK)fatherPKs.iterator().next()).isTrash() || !StringUtil.isDefined((String)(fieldValue = publication.getFieldValue(fieldName)))) continue;
            result.add(fieldValue);
        }
        return result;
    }

    public void draftInPublication(String xmlFormName, String fieldName, String fieldValue) {
        String publicationId = this.getPublicationId(xmlFormName, fieldName, fieldValue);
        if (publicationId != null) {
            PublicationPK publicationPK = new PublicationPK(publicationId, this.componentId);
            this.kmeliaService.draftInPublication(publicationPK);
        }
    }

    public void updatePublicationEndDate(String xmlFormName, String fieldName, String fieldValue, Date endDate) {
        String publicationToUpdateId = this.getPublicationId(xmlFormName, fieldName, fieldValue);
        PublicationPK publicationPK = new PublicationPK(publicationToUpdateId, this.spaceId, this.componentId);
        PublicationDetail pubDetail = this.kmeliaService.getPublicationDetail(publicationPK);
        Date publicationEndDate = pubDetail.getEndDate();
        if (publicationEndDate == null || publicationEndDate.after(endDate)) {
            pubDetail.setEndDate(endDate);
            this.updatePublication(pubDetail, false);
        }
    }

    private void updatePublicationDetail(PublicationDetail pubDetail, Map<String, String> parameters, String language) throws java.text.ParseException {
        String status = parameters.get("Status");
        String name = parameters.get("Name");
        String description = parameters.get("Description");
        String keywords = parameters.get("Keywords");
        String beginDate = parameters.get("BeginDate");
        String endDate = parameters.get("EndDate");
        String version = parameters.get("Version");
        String importance = parameters.get("Importance");
        String beginHour = parameters.get("BeginHour");
        String endHour = parameters.get("EndHour");
        String author = parameters.get("Author");
        String validatorId = parameters.get("ValideurId");
        String tempId = parameters.get("TempId");
        String infoId = parameters.get("InfoId");
        String updateDate = parameters.get("UpdateDate");
        if (StringUtil.isDefined((String)updateDate)) {
            pubDetail.setUpdateDate(DateUtil.stringToDate((String)updateDate, (String)language));
        }
        if (StringUtil.isDefined((String)beginDate)) {
            pubDetail.setBeginDate(DateUtil.stringToDate((String)beginDate, (String)language));
        }
        if (StringUtil.isDefined((String)endDate)) {
            pubDetail.setEndDate(DateUtil.stringToDate((String)endDate, (String)language));
        }
        if (name != null) {
            pubDetail.setName(name);
        }
        if (description != null) {
            pubDetail.setDescription(description);
        }
        if (StringUtil.isInteger((String)importance)) {
            pubDetail.setImportance(Integer.parseInt(importance));
        }
        if (version != null) {
            pubDetail.setVersion(version);
        }
        if (keywords != null) {
            pubDetail.setKeywords(keywords);
        }
        if (author != null) {
            pubDetail.setAuthor(author);
        }
        pubDetail.setBeginHour(beginHour);
        pubDetail.setEndHour(endHour);
        if (status != null) {
            pubDetail.setStatus(status);
        }
        if (StringUtil.isDefined((String)validatorId)) {
            pubDetail.setTargetValidatorId(validatorId);
        }
        pubDetail.setCloneId(tempId);
        if (StringUtil.isDefined((String)infoId)) {
            pubDetail.setInfoId(infoId);
        }
    }

    public void setIgnoreMissingFormFields(boolean ignore) {
        this.ignoreMissingFormFields = ignore;
    }

    private PublicationService getPublicationService() {
        return PublicationService.get();
    }
}

