/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.silverpeas.components.gallery.model.MediaOrderCriteriaProcessor;
import org.silverpeas.components.gallery.model.Order;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class MediaOrderSQLQueryBuilder
implements MediaOrderCriteriaProcessor {
    private boolean done = false;
    private final StringBuilder sqlQuery = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final List<Object> parameters = new ArrayList<Object>();
    private String conjunction = "";

    @Override
    public void startProcessing() {
        this.sqlQuery.append("O.orderId, O.userId, O.instanceId, O.createDate, O.processDate, O.processUser ");
        this.from.append("from SC_Gallery_Order O ");
    }

    @Override
    public void endProcessing() {
        this.sqlQuery.append(this.from.toString());
        if (this.where.length() > 0) {
            this.sqlQuery.append(" where ").append(this.where.toString());
        }
        this.done = true;
    }

    public JdbcSqlQuery result() {
        return JdbcSqlQuery.createSelect((String)this.sqlQuery.toString(), this.parameters);
    }

    @Override
    public MediaOrderCriteriaProcessor then() {
        if (!this.done) {
            this.conjunction = " and ";
        }
        return this;
    }

    @Override
    public MediaOrderCriteriaProcessor processComponentInstance(String componentInstanceId) {
        if (!this.done) {
            this.where(this.conjunction).append("O.instanceId = ?");
            this.parameters.add(componentInstanceId);
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaOrderCriteriaProcessor processOrderer(String ordererId) {
        if (!this.done) {
            this.where(this.conjunction).append("O.userId = ?");
            this.parameters.add(ordererId);
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaOrderCriteriaProcessor processNbDaysAfterThatDeleteAnOrder(Date referenceDate, int nbDaysAfterThatDeleteAnOrder) {
        if (!this.done) {
            this.where(this.conjunction).append("O.createDate < ?");
            this.parameters.add(DateUtils.addDays((Date)referenceDate, (int)(-nbDaysAfterThatDeleteAnOrder)));
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaOrderCriteriaProcessor processIdentifiers(List<String> identifiers) {
        if (!this.done) {
            StringBuilder params = new StringBuilder();
            for (String identifier : identifiers) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
                this.parameters.add(identifier);
            }
            this.where(this.conjunction).append("O.orderId in (").append(params.toString()).append(")");
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public List<Order> orderingResult(List<Order> orders) {
        return orders;
    }

    private StringBuilder where(String conjunction) {
        if (this.where.length() > 0) {
            this.where.append(conjunction);
        }
        return this.where;
    }
}

