/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.delegatednews.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.delegatednews.dao.DelegatedNewsRepository;
import org.silverpeas.components.delegatednews.model.DelegatedNews;
import org.silverpeas.components.delegatednews.notification.DelegatedNewsDeniedNotification;
import org.silverpeas.components.delegatednews.notification.DelegatedNewsToValidateNotification;
import org.silverpeas.components.delegatednews.notification.DelegatedNewsValidationNotification;
import org.silverpeas.components.delegatednews.service.DelegatedNewsService;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
@Transactional
public class DelegatedNewsServiceImpl
implements DelegatedNewsService,
ComponentInstanceDeletion {
    @Inject
    private DelegatedNewsRepository dao;
    @Inject
    private OrganizationController organizationController;

    public void delete(String componentInstanceId) {
        this.dao.deleteByComponentInstanceId(componentInstanceId);
    }

    @Override
    public void submitNews(Contribution contribution, Period visibilityPeriod, String userId) {
        DelegatedNews delegatedNews = new DelegatedNews(contribution.getIdentifier(), contribution.getLastUpdater().getId(), new Date(), visibilityPeriod);
        this.notifyDelegatedNewsToValidate(delegatedNews, userId);
        this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
    }

    @Override
    public DelegatedNews getDelegatedNews(String contributionId) {
        return (DelegatedNews)this.dao.getById(contributionId);
    }

    @Override
    public List<DelegatedNews> getDelegatedNews(Collection<String> contributionIds) {
        return this.dao.getById(contributionIds);
    }

    @Override
    public List<DelegatedNews> getAllDelegatedNews() {
        return this.dao.findAllOrderedNews();
    }

    @Override
    public List<DelegatedNews> getAllValidDelegatedNews() {
        return this.dao.findByStatus("Valid");
    }

    @Override
    public void validateDelegatedNews(String contributionId, String validatorId) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(contributionId);
        if (delegatedNews != null) {
            delegatedNews.setStatus("Valid");
            delegatedNews.setValidatorId(validatorId);
            delegatedNews.setValidationDate(new Date());
            this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
            this.notifyValidation(delegatedNews, validatorId);
        }
    }

    @Override
    public void refuseDelegatedNews(String contributionId, String validatorId, String refusalMotive) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(contributionId);
        if (delegatedNews != null) {
            delegatedNews.setStatus("Refused");
            delegatedNews.setValidatorId(validatorId);
            delegatedNews.setValidationDate(new Date());
            this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
            this.notifyDelegatedNewsRefused(delegatedNews, refusalMotive, validatorId);
        }
    }

    @Override
    public void updateDateDelegatedNews(String contributionId, Period visibilityPeriod) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(contributionId);
        if (delegatedNews != null) {
            delegatedNews.setVisibilityPeriod(visibilityPeriod);
            this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
        }
    }

    private OrganizationController getOrganisationController() {
        return this.organizationController;
    }

    private String getAppId() {
        String componentName = "delegatednews";
        return Stream.of(this.getOrganisationController().getCompoId("delegatednews")).map(i -> "delegatednews" + i).findFirst().orElseGet(() -> {
            SilverLogger.getLogger((Object)this).warn("No instance of 'DelegatedNews' found !", new Object[0]);
            return null;
        });
    }

    private void notifyDelegatedNewsToValidate(DelegatedNews news, String senderId) {
        String delegatedNewsInstanceId = this.getAppId();
        if (delegatedNewsInstanceId != null) {
            String[] editors = this.getOrganisationController().getUsersIdsByRoleNames(delegatedNewsInstanceId, Collections.singletonList("admin"));
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new DelegatedNewsToValidateNotification(news, User.getById((String)senderId), editors, delegatedNewsInstanceId));
        }
    }

    @Override
    public void updateDelegatedNews(ContributionIdentifier id, String updaterId, Period visibilityPeriod) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(id.getLocalId());
        if (delegatedNews != null) {
            delegatedNews.setInstanceId(id.getComponentInstanceId());
            delegatedNews.setStatus("ToValidate");
            delegatedNews.setContributorId(updaterId);
            delegatedNews.setValidatorId(null);
            delegatedNews.setValidationDate(new Date());
            delegatedNews.setVisibilityPeriod(visibilityPeriod);
            this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
            this.notifyDelegatedNewsToValidate(delegatedNews, updaterId);
        }
    }

    @Override
    public void deleteDelegatedNews(String contributionId) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(contributionId);
        if (delegatedNews != null) {
            this.dao.delete((IdentifiableEntity[])new DelegatedNews[]{delegatedNews});
        }
    }

    private void notifyValidation(DelegatedNews news, String senderId) {
        String delegatedNewsInstanceId = this.getAppId();
        if (delegatedNewsInstanceId != null) {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new DelegatedNewsValidationNotification(news, User.getById((String)senderId)));
        }
    }

    private void notifyDelegatedNewsRefused(DelegatedNews news, String refusalMotive, String userId) {
        String delegatedNewsInstanceId = this.getAppId();
        if (delegatedNewsInstanceId != null) {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new DelegatedNewsDeniedNotification(news, User.getById((String)userId), refusalMotive));
        }
    }

    @Override
    public DelegatedNews updateOrderDelegatedNews(String contributionId, int newsOrder) {
        DelegatedNews delegatedNews = (DelegatedNews)this.dao.getById(contributionId);
        delegatedNews.setNewsOrder(newsOrder);
        return (DelegatedNews)this.dao.saveAndFlush((IdentifiableEntity)delegatedNews);
    }
}

