/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningQueryResult;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.core.util.logging.SilverLogger;

public class DataWarningQuery
extends SilverpeasBean {
    private static final long serialVersionUID = -7619202031176865356L;
    public static final int QUERY_CONDITION_FIRST = 0;
    public static final int QUERY_CONDITION_AND = 1;
    public static final int QUERY_CONDITION_OR = 2;
    public static final int QUERY_TYPE_RESULT = 0;
    public static final int QUERY_TYPE_TRIGGER = 1;
    public static final int TRIGGER_CONDITION_SUP = 0;
    public static final int TRIGGER_CONDITION_SUP_OU_EG = 1;
    public static final int TRIGGER_CONDITION_INF = 2;
    public static final int TRIGGER_CONDITION_INF_OU_EG = 3;
    public static final int TRIGGER_CONDITION_EG = 4;
    public static final int TRIGGER_CONDITION_DIF = 5;
    public static final int QUERY_PERSO_NOT_VALID = 0;
    public static final int QUERY_PERSO_VALID = 1;
    public static final String QUERY_PERSO_UID_ID = "QUERY_PERSO_UID_ID";
    public static final String QUERY_PERSO_UID_LOGIN = "QUERY_PERSO_UID_LOGIN";
    public static final String QUERY_PERSO_UID_LASTNAME = "QUERY_PERSO_UID_LASTNAME";
    public static final String QUERY_PERSO_UID_SPECIFICID = "QUERY_PERSO_UID_SPECIFICID";
    public static final String QUERY_PERSO_UID_EMAIL = "QUERY_PERSO_UID_EMAIL";
    private String instanceId;
    private String description = "";
    private String query = "";
    private int queryCondition = 0;
    private int type = 0;
    private long theTrigger = 0L;
    private int theTriggerCondition = 0;
    private long theTriggerPrecedent = 0L;
    private String persoUID = "";
    private int persoColNB = 1;
    private int persoValid = 0;

    public DataWarningQuery() {
    }

    public DataWarningQuery(String instanceId) {
        this.instanceId = instanceId;
    }

    public DataWarningQuery(String instanceId, String description, String query, int queryCondition, int type, long theTrigger, int theTriggerCondition, long theTriggerPrecedent) {
        this.instanceId = instanceId;
        this.description = description;
        this.query = query;
        this.queryCondition = queryCondition;
        this.type = type;
        this.theTrigger = theTrigger;
        this.theTriggerCondition = theTriggerCondition;
        this.theTriggerPrecedent = theTriggerPrecedent;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getDescription() {
        return this.getSureString(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQuery() {
        return this.getSureString(this.query);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getQueryCondition() {
        return this.queryCondition;
    }

    public void setQueryCondition(int queryCondition) {
        this.queryCondition = queryCondition;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getTheTrigger() {
        return this.theTrigger;
    }

    public void setTheTrigger(long theTrigger) {
        this.theTrigger = theTrigger;
    }

    public int getTheTriggerCondition() {
        return this.theTriggerCondition;
    }

    public void setTheTriggerCondition(int theTriggerCondition) {
        this.theTriggerCondition = theTriggerCondition;
    }

    public long getTheTriggerPrecedent() {
        return this.theTriggerPrecedent;
    }

    public void setTheTriggerPrecedent(long theTriggerPrecedent) {
        this.theTriggerPrecedent = theTriggerPrecedent;
    }

    public int _getConnectionType() {
        return 1;
    }

    public String _getTableName() {
        return "SC_DataWarning_Query";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataWarningQueryResult executeQuery(DataWarning dataModel) {
        DataWarningQueryResult valret;
        ResultSet rs;
        PreparedStatement prepStmt;
        Connection con;
        block8: {
            con = null;
            prepStmt = null;
            rs = null;
            valret = new DataWarningQueryResult(this, this.getPersoValid() == 1, this.getPersoColNB(), this.getPersoUID());
            try {
                con = dataModel.openConnection();
                prepStmt = con.prepareStatement(this.getQuery());
                rs = prepStmt.executeQuery();
                if (rs == null) break block8;
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd != null) {
                    for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                        valret.addColumn(rsmd.getColumnName(i));
                    }
                }
                for (int j = 1; rs.next() && (dataModel.getRowLimit() <= 0 || j <= dataModel.getRowLimit()); ++j) {
                    ArrayList<String> ligne = new ArrayList<String>();
                    for (int k = 1; k < rsmd.getColumnCount() + 1; ++k) {
                        ligne.add(rs.getString(k));
                    }
                    valret.addRow(ligne);
                }
            }
            catch (Exception e) {
                try {
                    valret.addError(e, this.getQuery());
                    SilverLogger.getLogger((Object)((Object)this)).error("Fail to execute query " + this.getQuery(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, prepStmt);
                    dataModel.closeConnection(con);
                    throw throwable;
                }
                DBUtil.close((ResultSet)rs, (Statement)prepStmt);
                dataModel.closeConnection(con);
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        dataModel.closeConnection(con);
        return valret;
    }

    public boolean checkTriggerSatisfied(DataWarning dataModel) throws DataWarningException {
        return this.checkTriggerSatisfied(this.executeQuery(dataModel).returnTriggerValueFromResult());
    }

    public boolean checkTriggerSatisfied(long theValue) {
        boolean valret = true;
        switch (this.theTriggerCondition) {
            case 0: {
                valret = theValue > this.theTrigger;
                break;
            }
            case 1: {
                valret = theValue >= this.theTrigger;
                break;
            }
            case 2: {
                valret = theValue < this.theTrigger;
                break;
            }
            case 3: {
                valret = theValue <= this.theTrigger;
                break;
            }
            case 4: {
                valret = theValue == this.theTrigger;
                break;
            }
            case 5: {
                valret = theValue != this.theTrigger;
                break;
            }
        }
        return valret;
    }

    public int getPersoColNB() {
        return this.persoColNB;
    }

    public void setPersoColNB(int persoColNB) {
        this.persoColNB = persoColNB;
    }

    public String getPersoUID() {
        return this.persoUID;
    }

    public void setPersoUID(String persoUID) {
        this.persoUID = persoUID;
    }

    public int getPersoValid() {
        return this.persoValid;
    }

    public void setPersoValid(int persoValid) {
        this.persoValid = persoValid;
    }
}

