/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.classifieds.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.components.classifieds.dao.ClassifiedsDAO;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.model.ClassifiedsRuntimeException;
import org.silverpeas.components.classifieds.model.Subscribe;
import org.silverpeas.components.classifieds.notification.ClassifiedSubscriptionUserNotification;
import org.silverpeas.components.classifieds.notification.ClassifiedSupervisorUserNotification;
import org.silverpeas.components.classifieds.notification.ClassifiedValidationUserNotification;
import org.silverpeas.components.classifieds.service.ClassifiedService;
import org.silverpeas.core.NotFoundException;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.search.SearchEngineProvider;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
@Named(value="classifiedService")
public class DefaultClassifiedService
implements ClassifiedService {
    private static final String MESSAGES_PATH = "org.silverpeas.classifieds.multilang.classifiedsBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.classifieds.settings.classifiedsSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.classifieds.settings.classifiedsSettings");
    public static final String CLASSIFIED = "classified";
    public static final String CLASSIFIEDS_IN_APPLICATION = "classifieds in application";
    public static final String CLASSIFIED_TYPE = "Classified";
    private static final String NO_SUCH_CLASSIFIED = "No such classified ";
    @Inject
    private OrganizationController organizationController;

    @Override
    public Optional<ClassifiedDetail> getContributionById(ContributionIdentifier classifiedId) {
        Optional<ClassifiedDetail> optional;
        block8: {
            Connection con = this.openConnection();
            try {
                optional = Optional.ofNullable(ClassifiedsDAO.getClassified(con, classifiedId.getLocalId()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)CLASSIFIED, (Object)classifiedId), e);
                }
            }
            con.close();
        }
        return optional;
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith(CLASSIFIED);
    }

    @Override
    public String createClassified(ClassifiedDetail classified) {
        String string;
        block9: {
            Connection con = this.openConnection();
            try {
                String id = ClassifiedsDAO.createClassified(con, classified);
                classified.setClassifiedId(Integer.parseInt(id));
                this.createIndex(classified);
                if (classified.isToValidate()) {
                    this.sendAlertToSupervisors(classified);
                }
                string = id;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnAdding((String)CLASSIFIED, (Object)""), e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public void deleteClassified(ContributionIdentifier classifiedId) {
        this.deleteClassified(classifiedId, this.getTemplate(classifiedId.getComponentInstanceId()));
    }

    private void deleteClassified(ContributionIdentifier classifiedId, PublicationTemplate template) {
        ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
        try {
            RecordSet set = template.getRecordSet();
            set.delete(classifiedId.getLocalId());
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)"form of the classified", (Object)classifiedId.getLocalId()), e);
        }
        try {
            ResourceReference classifiedForeignKey = new ResourceReference(classifiedId);
            SimpleDocumentList images = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(classifiedForeignKey, DocumentType.attachment, null);
            for (SimpleDocument classifiedImage : images) {
                AttachmentServiceProvider.getAttachmentService().deleteAttachment(classifiedImage);
            }
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)"images of the classified", (Object)classifiedId), e);
        }
        try (Connection con = this.openConnection();){
            ClassifiedsDAO.deleteClassified(con, classifiedId.getLocalId());
        }
        catch (SQLException e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)CLASSIFIED, (Object)classifiedId), e);
        }
        this.deleteIndex(classified);
    }

    @Override
    public void unpublishClassified(ContributionIdentifier classifiedId) {
        try {
            ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
            classified.setStatus("Unpublished");
            classified.setUpdateDate(new Date());
            this.updateClassified(classified);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnUpdate((String)CLASSIFIED, (Object)classifiedId), e);
        }
    }

    @Override
    public void deleteAllClassifieds(String instanceId) {
        PublicationTemplate template = this.getTemplate(instanceId);
        Collection<ClassifiedDetail> classifieds = this.getAllClassifieds(instanceId);
        for (ClassifiedDetail classified : classifieds) {
            this.deleteClassified(classified.getIdentifier(), template);
        }
    }

    private void updateClassified(ClassifiedDetail classified) {
        this.updateClassified(classified, false);
    }

    @Override
    public void updateClassified(ClassifiedDetail classified, boolean notify) {
        try (Connection con = this.openConnection();){
            ClassifiedsDAO.updateClassified(con, classified);
            this.createIndex(classified);
            if (notify) {
                this.sendAlertToSupervisors(classified);
            }
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnUpdate((String)CLASSIFIED, (Object)classified), e);
        }
    }

    @Override
    public Collection<ClassifiedDetail> getAllClassifieds(String instanceId) {
        Collection<ClassifiedDetail> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ClassifiedsDAO.getAllClassifieds(con, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all classifieds in application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public String getNbTotalClassifieds(String instanceId) {
        String string;
        block8: {
            Connection con = this.openConnection();
            try {
                string = ClassifiedsDAO.getNbTotalClassifieds(con, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)CLASSIFIED, (Object)"count"), e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public List<ClassifiedDetail> getClassifiedsByUser(String instanceId, String userId) {
        List<ClassifiedDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ClassifiedsDAO.getClassifiedsByUser(con, instanceId, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"classifieds of the user", (Object)userId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<ClassifiedDetail> getClassifiedsToValidate(String instanceId) {
        List<ClassifiedDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ClassifiedsDAO.getClassifiedsWithStatus(con, instanceId, "ToValidate", 0, -1);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"classifieds to validate in application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public void validateClassified(ContributionIdentifier classifiedId, String userId) {
        try {
            ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
            if (classified.isToValidate()) {
                classified.setValidatorId(userId);
                classified.setValidateDate(new Date());
                classified.setStatus("Valid");
            }
            this.updateClassified(classified);
            this.sendValidationNotification(classified.getCreatorId(), classified, null, userId);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnValidating((String)CLASSIFIED, (Object)classifiedId), e);
        }
    }

    @Override
    public void refusedClassified(ContributionIdentifier classifiedId, String userId, String refusalMotive) {
        try {
            ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
            classified.setStatus("Unvalidate");
            this.updateClassified(classified);
            this.sendValidationNotification(classified.getCreatorId(), classified, refusalMotive, userId);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnValidating((String)CLASSIFIED, (Object)classifiedId), e);
        }
    }

    private void sendValidationNotification(String userId, ClassifiedDetail classified, String refusalMotive, String userIdWhoRefuse) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new ClassifiedValidationUserNotification(classified, userIdWhoRefuse, refusalMotive, userId));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @Override
    public void sendSubscriptionsNotification(String field1, String field2, ClassifiedDetail classified) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new ClassifiedSubscriptionUserNotification(classified, this.getUsersBySubscribe(field1, field2)));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @Override
    public Collection<ClassifiedDetail> getAllClassifiedsToUnpublish(int nbDays, String instanceId) {
        List<ClassifiedDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ClassifiedsDAO.getAllClassifiedsToUnpublish(con, nbDays, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"all classifieds to unpublish in application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<ClassifiedDetail> search(QueryDescription query) {
        ArrayList<ClassifiedDetail> classifieds = new ArrayList<ClassifiedDetail>();
        try {
            List result = SearchEngineProvider.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry matchIndex : result) {
                if (!CLASSIFIED_TYPE.equals(matchIndex.getObjectType())) continue;
                ContributionIdentifier classifiedId = ContributionIdentifier.from((String)"", (String)matchIndex.getObjectId(), (String)ClassifiedDetail.getResourceType());
                this.getContributionById(classifiedId).filter(ClassifiedDetail::isValid).ifPresent(classifieds::add);
            }
            Collections.reverse(classifieds);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(e.getMessage(), e);
        }
        return classifieds;
    }

    @Override
    public void indexClassifieds(String instanceId) {
        Collection<ClassifiedDetail> classifieds = this.getAllClassifieds(instanceId);
        if (classifieds != null) {
            PublicationTemplate template = this.getTemplate(instanceId);
            for (ClassifiedDetail classified : classifieds) {
                this.createIndex(classified, template);
            }
        }
    }

    private void createIndex(ClassifiedDetail classified) {
        if (classified != null) {
            this.createIndex(classified, this.getTemplate(classified.getInstanceId()));
        }
    }

    private void createIndex(ClassifiedDetail classified, PublicationTemplate template) {
        if (classified != null) {
            FullIndexEntry indexEntry = new FullIndexEntry(classified.getInstanceId(), CLASSIFIED_TYPE, Integer.toString(classified.getClassifiedId()));
            indexEntry.setTitle(classified.getTitle());
            indexEntry.setPreview(classified.getDescription());
            indexEntry.setCreationDate(classified.getCreationDate());
            indexEntry.setCreationUser(classified.getCreatorId());
            indexEntry.setLastModificationDate(classified.getUpdateDate());
            String xmlFormShortName = FilenameUtils.getBaseName((String)template.getFileName());
            try {
                RecordSet set = template.getRecordSet();
                String classifiedId = Integer.toString(classified.getClassifiedId());
                set.indexRecord(classifiedId, xmlFormShortName, indexEntry);
            }
            catch (Exception e) {
                throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnIndexing((String)CLASSIFIED, (Object)classified.getId()), e);
            }
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private PublicationTemplate getTemplate(String instanceId) {
        try {
            String xmlFormName = this.organizationController.getComponentParameterValue(instanceId, "XMLFormName");
            if (StringUtil.isDefined((String)xmlFormName)) {
                String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
                return PublicationTemplateManager.getInstance().getPublicationTemplate(instanceId + ":" + xmlFormShortName);
            }
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"classified form for application", (Object)instanceId), e);
        }
        throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"classified form for application", (Object)instanceId));
    }

    public void deleteIndex(ClassifiedDetail classified) {
        IndexEntryKey indexEntry = new IndexEntryKey(classified.getInstanceId(), CLASSIFIED_TYPE, Integer.toString(classified.getClassifiedId()));
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    @Override
    public void draftOutClassified(ContributionIdentifier classifiedId, String profile, boolean isValidationEnabled) {
        ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
        String status = classified.getStatus();
        if (classified.isDraft()) {
            status = "admin".equals(profile) || !isValidationEnabled ? "Valid" : "ToValidate";
            classified.setStatus(status);
            this.sendAlertToSupervisors(classified);
        }
        classified.setStatus(status);
        this.updateClassified(classified);
    }

    private void sendAlertToSupervisors(ClassifiedDetail classified) {
        if (classified.isToValidate()) {
            try {
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new ClassifiedSupervisorUserNotification(classified));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    @Override
    public void draftInClassified(ContributionIdentifier classifiedId) {
        ClassifiedDetail classified = this.getContributionById(classifiedId).orElseThrow(() -> new NotFoundException(NO_SUCH_CLASSIFIED + classifiedId.asString()));
        String status = classified.getStatus();
        if (classified.isToValidate() || classified.isValid()) {
            status = "Draft";
        }
        classified.setStatus(status);
        this.updateClassified(classified);
    }

    @Override
    public void createSubscribe(Subscribe subscribe) {
        try (Connection con = this.openConnection();){
            if (this.checkSubscription(subscribe)) {
                String id = ClassifiedsDAO.createSubscribe(con, subscribe);
                subscribe.setSubscribeId(id);
            }
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnSubscribing((String)CLASSIFIEDS_IN_APPLICATION, (String)subscribe.getInstanceId()), e);
        }
    }

    @Override
    public void deleteSubscribe(String subscribeId) {
        try (Connection con = this.openConnection();){
            ClassifiedsDAO.deleteSubscribe(con, subscribeId);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)"subscription", (Object)subscribeId), e);
        }
    }

    public boolean checkSubscription(Subscribe subscribe) {
        try {
            Collection<Subscribe> subscriptions = this.getSubscribesByUser(subscribe.getInstanceId(), subscribe.getUserId());
            for (Subscribe sub : subscriptions) {
                if (!sub.getField1().equals(subscribe.getField1()) || !sub.getField2().equals(subscribe.getField2())) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<Subscribe> getSubscribesByUser(String instanceId, String userId) {
        Collection<Subscribe> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ClassifiedsDAO.getSubscribesByUser(con, instanceId, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"subscriptions of the user", (Object)userId), e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<String> getUsersBySubscribe(String field1, String field2) {
        Collection<String> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ClassifiedsDAO.getUsersBySubscribe(con, field1, field2);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"subscriptions", (Object)""), e);
                }
            }
            con.close();
        }
        return collection;
    }

    public Collection<Subscribe> getAllSubscribes(String instanceId) {
        Collection<Subscribe> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ClassifiedsDAO.getAllSubscribes(con, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"subscriptions for application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public void deleteAllSubscribes(String instanceId) {
        Collection<Subscribe> subscribes = this.getAllSubscribes(instanceId);
        for (Subscribe subscribe : subscribes) {
            this.deleteSubscribe(subscribe.getSubscribeId());
        }
    }

    @Override
    public List<ClassifiedDetail> getAllValidClassifieds(String instanceId) {
        List<ClassifiedDetail> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ClassifiedsDAO.getClassifiedsWithStatus(con, instanceId, "Valid", -1, -1);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"valid classifieds in application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<ClassifiedDetail> getAllValidClassifieds(String instanceId, Map<String, String> mapFields1, Map<String, String> mapFields2, String searchField1, String searchField2, int firstItemIndex, int elementsPerPage) {
        List<ClassifiedDetail> list;
        block9: {
            Connection con = this.openConnection();
            try {
                List<ClassifiedDetail> listClassified = ClassifiedsDAO.getClassifiedsWithStatus(con, instanceId, "Valid", firstItemIndex, elementsPerPage);
                String xmlFormName = this.organizationController.getComponentParameterValue(instanceId, "XMLFormName");
                for (ClassifiedDetail classified : listClassified) {
                    classified.setCreatorName(UserDetail.getById((String)classified.getCreatorId()).getDisplayedName());
                    this.setClassification(classified, searchField1, searchField2, xmlFormName);
                    this.addImages(instanceId, classified);
                }
                list = listClassified;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"valid classifieds in application", (Object)instanceId), e);
                }
            }
            con.close();
        }
        return list;
    }

    private void addImages(String instanceId, ClassifiedDetail classified) {
        try {
            String classifiedId = Integer.toString(classified.getClassifiedId());
            ResourceReference classifiedForeignKey = new ResourceReference(classifiedId, instanceId);
            SimpleDocumentList listSimpleDocument = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(classifiedForeignKey, DocumentType.attachment, null);
            classified.setImages((List<SimpleDocument>)listSimpleDocument);
        }
        catch (Exception e) {
            throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"images of valid classifieds in application", (Object)instanceId), e);
        }
    }

    @Override
    public void setClassification(ClassifiedDetail classified, String searchField1, String searchField2, String xmlFormName) {
        if (StringUtil.isDefined((String)xmlFormName)) {
            String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
            try {
                PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(classified.getInstanceId() + ":" + xmlFormShortName);
                if (pubTemplate != null) {
                    RecordSet recordSet = pubTemplate.getRecordSet();
                    DataRecord data = recordSet.getRecord(classified.getId());
                    Map values = data.getValues("fr");
                    Field field1 = data.getField(searchField1);
                    String searchValueId1 = field1.getValue();
                    String searchValue1 = (String)values.get(searchField1);
                    Field field2 = data.getField(searchField2);
                    String searchValueId2 = field2.getValue();
                    String searchValue2 = (String)values.get(searchField2);
                    classified.setSearchValueId1(searchValueId1);
                    classified.setSearchValueId2(searchValueId2);
                    classified.setSearchValue1(searchValue1);
                    classified.setSearchValue2(searchValue2);
                }
            }
            catch (Exception e) {
                throw new ClassifiedsRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)CLASSIFIED, (Object)classified.getId()), e);
            }
        }
    }

    private Connection openConnection() {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new ClassifiedsRuntimeException(e.getMessage(), e);
        }
        return con;
    }
}

