/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.model;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.silverpeas.core.SilverpeasException;
import org.silverpeas.core.io.media.image.ImageInfoType;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.util.ImageUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.viewer.model.Preview;

public abstract class AbstractPreview
implements Preview {
    private static final long serialVersionUID = 3597757215012779572L;
    private final String documentId;
    private final String language;
    private final String originalFileName;
    private final File physicalFile;
    private String[] widthAndHeight = null;

    @Override
    public String getDisplayLicenseKey() {
        return "";
    }

    AbstractPreview(String documentId, String language, String originalFileName, File physicalFile) {
        this.documentId = documentId;
        this.language = language;
        this.originalFileName = originalFileName;
        this.physicalFile = physicalFile;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    @Override
    public File getPhysicalFile() {
        return this.physicalFile;
    }

    @Override
    public String getWidth() {
        return this.getWidthAndHeight()[0];
    }

    @Override
    public String getHeight() {
        return this.getWidthAndHeight()[1];
    }

    @Override
    public String getURLAsString() {
        return FileServerUtils.getUrlToTempDir((String)(this.getPhysicalFile().getParentFile().getName() + "/" + this.getPhysicalFile().getName()));
    }

    @Override
    public Path getServerFilePath() {
        return Paths.get(FileRepositoryManager.getTemporaryPath(), this.getPhysicalFile().getParentFile().getName(), this.getPhysicalFile().getName());
    }

    private String[] getWidthAndHeight() {
        if (this.widthAndHeight == null) {
            ImageTool imageTool = ImageTool.get();
            if (imageTool.isActivated()) {
                try {
                    this.widthAndHeight = imageTool.getImageInfo(this.physicalFile, new ImageInfoType[]{ImageInfoType.WIDTH_IN_PIXEL, ImageInfoType.HEIGHT_IN_PIXEL});
                }
                catch (SilverpeasException e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
            }
            if (this.widthAndHeight == null) {
                this.widthAndHeight = ImageUtil.getWidthAndHeight((File)this.physicalFile);
            }
        }
        return this.widthAndHeight;
    }
}

