/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.util.StringUtil;

@Entity
@Table(name="sc_resources_category")
@NamedQueries(value={@NamedQuery(name="category.findByInstanceId", query="SELECT category FROM Category category WHERE category.instanceId = :instanceId ORDER BY category.name")})
public class Category
extends BasicJpaEntity<Category, UniqueLongIdentifier> {
    private static final long serialVersionUID = 4947144625712662946L;
    @Column
    private String instanceId;
    @Column
    private String name;
    @Column
    private String creationDate;
    @Column
    private String updateDate;
    @Column
    private Integer bookable;
    @Column
    private String form;
    @Column
    private String createrId;
    @Column
    private String updaterId;
    @Column
    private String description;
    @OneToMany(mappedBy="category", orphanRemoval=false)
    private List<Resource> resources = new ArrayList<Resource>();

    public void performBeforePersist() {
        Date now = new Date();
        this.setCreationDate(now);
        this.setUpdateDate(now);
    }

    public void performBeforeUpdate() {
        this.setUpdateDate(new Date());
    }

    public boolean isBookable() {
        return 1 == this.bookable;
    }

    public void setBookable(boolean bookable) {
        this.bookable = bookable ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public Long getIdAsLong() {
        return ((UniqueLongIdentifier)this.getNativeId()).getId();
    }

    public String getIdAsString() {
        return this.getId();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public Category() {
    }

    public Category(String name, boolean bookable, String form, String description) {
        this.name = name;
        this.setBookable(bookable);
        this.form = form;
        this.description = description;
    }

    public Category(Long id, String instanceId, String name, boolean bookable, String form, String createrId, String updaterId, String description) {
        this.setId(Long.toString(id));
        this.instanceId = instanceId;
        this.name = name;
        this.setBookable(bookable);
        this.form = form;
        this.createrId = createrId;
        this.updaterId = updaterId;
        this.description = description;
    }

    public Date getCreationDate() {
        if (StringUtil.isLong((String)this.creationDate)) {
            Date create = new Date();
            create.setTime(Long.parseLong(this.creationDate));
            return create;
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        if (creationDate != null) {
            this.creationDate = String.valueOf(creationDate.getTime());
        }
    }

    public Date getUpdateDate() {
        if (StringUtil.isLong((String)this.updateDate)) {
            Date update = new Date();
            update.setTime(Long.parseLong(this.updateDate));
            return update;
        }
        return null;
    }

    public void setUpdateDate(Date updateDate) {
        if (updateDate != null) {
            this.updateDate = String.valueOf(updateDate.getTime());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)((Object)obj);
        EqualsBuilder matcher = new EqualsBuilder();
        matcher.append((Object)this.getId(), (Object)other.getId());
        matcher.append((Object)this.getInstanceId(), (Object)other.getInstanceId());
        matcher.append((Object)this.getName(), (Object)other.getName());
        matcher.append(this.isBookable(), other.isBookable());
        matcher.append((Object)this.getForm(), (Object)other.getForm());
        matcher.append((Object)this.getCreaterId(), (Object)other.getCreaterId());
        matcher.append((Object)this.getUpdaterId(), (Object)other.getUpdaterId());
        matcher.append((Object)this.getDescription(), (Object)other.getDescription());
        return matcher.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append((Object)this.getId());
        hash.append((Object)this.getInstanceId());
        hash.append((Object)this.getName());
        hash.append(this.isBookable());
        hash.append((Object)this.getForm());
        hash.append((Object)this.getCreaterId());
        hash.append((Object)this.getUpdaterId());
        hash.append((Object)this.getDescription());
        return hash.toHashCode();
    }

    public String toString() {
        return "Category{id=" + this.getId() + ", instanceId=" + this.instanceId + ", name=" + this.name + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ", bookable=" + this.bookable + ", form=" + this.form + ", createrId=" + this.createrId + ", updaterId=" + this.updaterId + ", description=" + this.description + "}";
    }
}

