/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.MediaCriteriaProcessor;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;

public class MediaCriteria {
    private UserDetail requester;
    private SilverpeasRole componentHighestRequesterRole;
    private String componentInstanceId;
    private UserDetail creator;
    private final List<String> albumIds = new ArrayList<String>();
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private final List<QUERY_ORDER_BY> orderByList = new ArrayList<QUERY_ORDER_BY>();
    private final List<String> identifiers = new ArrayList<String>();
    private VISIBILITY visibility = VISIBILITY.BY_DEFAULT;
    private Date referenceDate = DateUtil.getDate();
    private Integer nbDaysBeforeThatMediaIsNotVisible;
    private int resultLimit = 0;

    private MediaCriteria() {
    }

    public static MediaCriteria fromComponentInstanceId(String componentInstanceId) {
        MediaCriteria criteria = new MediaCriteria();
        criteria.onComponentInstanceId(componentInstanceId);
        return criteria;
    }

    public static MediaCriteria fromMediaId(String mediaId) {
        MediaCriteria criteria = new MediaCriteria();
        criteria.identifierIsOneOf(mediaId);
        return criteria;
    }

    public static MediaCriteria fromNbDaysBeforeThatMediaIsNotVisible(Integer nbDaysBeforeThatMediaIsNotVisible) {
        MediaCriteria criteria = new MediaCriteria();
        criteria.nbDaysBeforeThatMediaIsNotVisible = nbDaysBeforeThatMediaIsNotVisible;
        return criteria;
    }

    public MediaCriteria onComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
        return this;
    }

    public MediaCriteria setRequester(UserDetail requester) {
        this.requester = requester;
        this.componentHighestRequesterRole = null;
        return this;
    }

    public MediaCriteria createdBy(UserDetail user) {
        this.creator = user;
        return this;
    }

    public MediaCriteria albumIdentifierIsOneOf(String ... albumIds) {
        CollectionUtil.addAllIgnoreNull(this.albumIds, (Object[])albumIds);
        return this;
    }

    public MediaCriteria mediaTypeIsOneOf(MediaType ... mediaTypes) {
        CollectionUtil.addAllIgnoreNull(this.mediaTypes, (Object[])mediaTypes);
        return this;
    }

    public MediaCriteria orderedBy(QUERY_ORDER_BY ... orderBies) {
        CollectionUtil.addAllIgnoreNull(this.orderByList, (Object[])orderBies);
        return this;
    }

    public MediaCriteria identifierIsOneOf(String ... identifiers) {
        CollectionUtil.addAllIgnoreNull(this.identifiers, (Object[])identifiers);
        return this;
    }

    public MediaCriteria withVisibility(VISIBILITY visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException("visibility parameter must not be null");
        }
        this.visibility = visibility;
        return this;
    }

    public MediaCriteria referenceDateOf(Date referenceDate) {
        if (referenceDate == null) {
            throw new IllegalArgumentException("dateReference parameter must not be null");
        }
        this.referenceDate = referenceDate;
        return this;
    }

    public MediaCriteria limitResultTo(int nbMedia) {
        this.resultLimit = nbMedia;
        return this;
    }

    public int getResultLimit() {
        return this.resultLimit;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    private UserDetail getRequester() {
        if (this.requester == null) {
            return UserDetail.getCurrentRequester();
        }
        return this.requester;
    }

    private SilverpeasRole getComponentHighestRequesterRole() {
        if (this.componentHighestRequesterRole == null) {
            Set requesterRoles = SilverpeasRole.fromStrings((String[])OrganizationControllerProvider.getOrganisationController().getUserProfiles(this.getRequester().getId(), this.getComponentInstanceId()));
            this.componentHighestRequesterRole = SilverpeasRole.getHighestFrom((Collection)requesterRoles);
        }
        return this.componentHighestRequesterRole;
    }

    private UserDetail getCreator() {
        return this.creator;
    }

    private List<String> getAlbumIds() {
        return this.albumIds;
    }

    private List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    private List<String> getIdentifiers() {
        return this.identifiers;
    }

    private List<QUERY_ORDER_BY> getOrderByList() {
        return this.orderByList;
    }

    private VISIBILITY getVisibility() {
        return this.visibility;
    }

    private Date getReferenceDate() {
        return this.referenceDate;
    }

    public Integer getNbDaysBeforeThatMediaIsNotVisible() {
        return this.nbDaysBeforeThatMediaIsNotVisible;
    }

    public void processWith(MediaCriteriaProcessor processor) {
        processor.startProcessing();
        boolean isComponentCriteriaDefined = StringUtil.isDefined((String)this.getComponentInstanceId());
        if (isComponentCriteriaDefined) {
            processor.processComponentInstance(this.getComponentInstanceId());
        }
        UserDetail creatorForVisibility = null;
        VISIBILITY theVisibility = this.getVisibility();
        if (this.getRequester() != null) {
            if (theVisibility == VISIBILITY.BY_DEFAULT && (this.getRequester().isAccessAdmin() || isComponentCriteriaDefined && this.getComponentHighestRequesterRole() != null && this.getComponentHighestRequesterRole().isGreaterThanOrEquals(SilverpeasRole.PUBLISHER))) {
                theVisibility = VISIBILITY.FORCE_GET_ALL;
            } else if (isComponentCriteriaDefined && this.getComponentHighestRequesterRole() == SilverpeasRole.WRITER) {
                creatorForVisibility = this.getRequester();
            }
        }
        processor.then().processVisibility(theVisibility, this.getReferenceDate(), creatorForVisibility);
        if (!this.getAlbumIds().isEmpty()) {
            processor.then().processAlbums(this.getAlbumIds());
        }
        if (!this.getIdentifiers().isEmpty()) {
            processor.then().processIdentifiers(this.getIdentifiers());
        }
        if (this.getCreator() != null) {
            processor.then().processCreator(this.getCreator());
        }
        if (!this.getMediaTypes().isEmpty()) {
            processor.then().processMediaTypes(this.getMediaTypes());
        }
        if (this.getNbDaysBeforeThatMediaIsNotVisible() != null) {
            processor.then().processNbDaysBeforeThatMediaIsNotVisible(this.getReferenceDate(), this.getNbDaysBeforeThatMediaIsNotVisible());
        }
        if (!this.getOrderByList().isEmpty()) {
            processor.then().processOrdering(this.getOrderByList());
        }
        processor.processResultLimit(this.getResultLimit());
        processor.endProcessing();
    }

    public static enum QUERY_ORDER_BY {
        SIZE_ASC(false, "size", true),
        SIZE_DESC(false, "size", false),
        DIMENSION_ASC(false, "dimension", true),
        DIMENSION_DESC(false, "dimension", false),
        COMPONENT_INSTANCE_ASC(true, "M.instanceId", true),
        COMPONENT_INSTANCE_DESC(true, "M.instanceId", false),
        IDENTIFIER_ASC(true, "M.mediaId", true),
        IDENTIFIER_DESC(true, "M.mediaId", false),
        CREATE_DATE_ASC(true, "M.createDate", true),
        CREATE_DATE_DESC(true, "M.createDate", false),
        LAST_UPDATE_DATE_ASC(true, "M.lastUpdateDate", true),
        LAST_UPDATE_DATE_DESC(true, "M.lastUpdateDate", false),
        TITLE_ASC(true, "LOWER(M.title)", true),
        TITLE_DESC(true, "LOWER(M.title)", false),
        AUTHOR_ASC_EMPTY_END(false, "M.author", true),
        AUTHOR_DESC_EMPTY_END(false, "M.author", false),
        AUTHOR_ASC(true, "LOWER(M.author)", true),
        AUTHOR_DESC(true, "LOWER(M.author)", false);

        private final boolean applicableOnSQLQuery;
        private final String instructionBase;
        private final boolean asc;

        private QUERY_ORDER_BY(boolean applicableOnSQLQuery, String instructionBase, boolean asc) {
            this.applicableOnSQLQuery = applicableOnSQLQuery;
            this.instructionBase = instructionBase;
            this.asc = asc;
        }

        public static QUERY_ORDER_BY fromPropertyName(String property, String sort) {
            QUERY_ORDER_BY orderBy = null;
            for (QUERY_ORDER_BY queryOrderBy : QUERY_ORDER_BY.values()) {
                String orderByName = queryOrderBy.name().toLowerCase();
                if (!orderByName.startsWith(property.toLowerCase()) || !orderByName.endsWith(sort.toLowerCase())) continue;
                orderBy = queryOrderBy;
            }
            return orderBy;
        }

        public boolean isApplicableOnSQLQuery() {
            return this.applicableOnSQLQuery;
        }

        public String getInstructionBase() {
            return this.instructionBase;
        }

        public boolean isAsc() {
            return this.asc;
        }
    }

    public static enum VISIBILITY {
        BY_DEFAULT,
        VISIBLE_ONLY,
        HIDDEN_ONLY,
        FORCE_GET_ALL;

    }
}

