/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.job;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.silverpeas.components.mailinglist.service.event.MessageEvent;
import org.silverpeas.components.mailinglist.service.event.MessageListener;
import org.silverpeas.components.mailinglist.service.model.beans.Attachment;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.util.HtmlCleaner;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class MailProcessor {
    public static final int SUMMARY_SIZE = 200;
    public static final String MAIL_HEADER_IN_REPLY_TO = "In-Reply-To";
    public static final String MAIL_HEADER_REFERENCES = "References";
    private SilverLogger logger = SilverLogger.getLogger((Object)this);
    @Inject
    private HtmlCleaner cleaner;

    public void setCleaner(HtmlCleaner cleaner) {
        this.cleaner = cleaner;
        this.cleaner.setSummarySize(200);
    }

    public void processMailPart(Part part, Message message) throws MessagingException, IOException {
        if (!this.isTextPart(part)) {
            Object content = part.getContent();
            if (content instanceof Multipart) {
                this.processMultipart((Multipart)content, message);
            } else {
                String fileName = this.getFileName(part);
                if (fileName != null) {
                    Attachment attachment = new Attachment();
                    attachment.setSize(part.getSize());
                    attachment.setFileName(fileName);
                    attachment.setContentType(MailProcessor.extractContentType(part.getContentType()));
                    String attachmentPath = this.saveAttachment(part, message.getComponentId(), message.getMessageId());
                    attachment.setPath(attachmentPath);
                    message.getAttachments().add(attachment);
                }
            }
        } else {
            this.processBody((String)part.getContent(), MailProcessor.extractContentType(part.getContentType()), message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBody(String content, String contentType, Message message) throws IOException, MessagingException {
        if (message.getContentType() != null && message.getContentType().contains("text/html")) {
            return;
        }
        message.setContentType(contentType);
        if (contentType == null) {
            message.setContentType("text/plain");
        }
        if (message.getContentType().contains("text/plain")) {
            message.setBody(content);
            if (message.getBody().length() > 200) {
                message.setSummary(message.getBody().substring(0, 200));
            } else {
                message.setSummary(message.getBody());
            }
        } else if (message.getContentType().contains("text/html")) {
            message.setBody(content);
            try (StringReader reader = null;){
                reader = new StringReader(content);
                this.cleaner.parse(reader);
                message.setSummary(this.cleaner.getSummary());
            }
        } else {
            message.setContentType("text/plain");
            message.setBody(content);
            if (message.getBody().length() > 200) {
                message.setSummary(message.getBody().substring(0, 200));
            } else {
                message.setSummary(message.getBody());
            }
        }
    }

    public String replaceSpecialChars(String toParse) {
        if (toParse == null) {
            return "";
        }
        String newLogicalName = toParse.replace(' ', '_');
        newLogicalName = newLogicalName.replace('\'', '_');
        newLogicalName = newLogicalName.replace('-', '_');
        newLogicalName = newLogicalName.replace('#', '_');
        newLogicalName = newLogicalName.replace('%', '_');
        newLogicalName = newLogicalName.replace('>', '_');
        newLogicalName = newLogicalName.replace('<', '_');
        newLogicalName = newLogicalName.replace('\\', '_');
        newLogicalName = newLogicalName.replace('/', '_');
        newLogicalName = newLogicalName.replace('?', '_');
        newLogicalName = newLogicalName.replace(':', '_');
        newLogicalName = newLogicalName.replace('|', '_');
        newLogicalName = newLogicalName.replace('\"', '_');
        return newLogicalName;
    }

    public String saveAttachment(Part part, String componentId, String messageId) throws IOException, MessagingException {
        File parentDir = new File(FileRepositoryManager.getAbsolutePath((String)componentId) + this.replaceSpecialChars(messageId));
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        File targetFile = new File(parentDir, this.getFileName(part));
        try (InputStream partIn = part.getInputStream();){
            Files.copy(partIn, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return targetFile.getAbsolutePath();
    }

    public void prepareMessage(MimeMessage mail, MessageListener mailingList, MessageEvent event) throws MessagingException, IOException {
        String sender = ((InternetAddress[])mail.getFrom())[0].getAddress();
        if (!mailingList.checkSender(sender)) {
            return;
        }
        Message message = new Message();
        message.setComponentId(mailingList.getComponentId());
        message.setSender(sender);
        message.setSentDate(mail.getSentDate());
        message.setMessageId(mail.getMessageID());
        String[] referenceId = mail.getHeader(MAIL_HEADER_IN_REPLY_TO);
        if (referenceId == null || referenceId.length == 0) {
            referenceId = mail.getHeader(MAIL_HEADER_REFERENCES);
        }
        if (referenceId == null || referenceId.length == 0) {
            message.setReferenceId(null);
        } else {
            message.setReferenceId(referenceId[0]);
        }
        message.setTitle(mail.getSubject());
        Object content = mail.getContent();
        if (content instanceof Multipart) {
            this.processMultipart((Multipart)content, message);
        } else if (content instanceof String) {
            this.processBody((String)content, mail.getContentType(), message);
        }
        event.addMessage(message);
    }

    protected static String extractContentType(String contentType) {
        try {
            ContentType type = new ContentType(contentType);
            return type.getBaseType();
        }
        catch (ParseException e) {
            SilverLogger.getLogger(MailProcessor.class).error((Throwable)e);
            return contentType;
        }
    }

    protected String getFileName(Part part) throws MessagingException {
        String fileName = part.getFileName();
        if (fileName == null) {
            try {
                ContentType type = new ContentType(part.getContentType());
                fileName = type.getParameter("name");
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return fileName;
    }

    protected boolean isTextPart(Part part) throws MessagingException {
        String disposition = part.getDisposition();
        if (!"attachment".equals(disposition) && !"inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType());
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else if ("inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType()) && this.getFileName(part) == null;
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void processMultipart(Multipart multipart, Message message) throws MessagingException, IOException {
        int partsNumber = multipart.getCount();
        for (int i = 0; i < partsNumber; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            this.processMailPart((Part)part, message);
        }
    }
}

