/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.MediaCriteriaProcessor;
import org.silverpeas.components.gallery.model.MediaLogicalComparator;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.date.DateTime;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;

public class MediaSQLQueryBuilder
implements MediaCriteriaProcessor {
    private final boolean count;
    private StringBuilder orderBy = null;
    private boolean done = false;
    private final StringBuilder sqlQuery = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final List<Object> parameters = new ArrayList<Object>();
    private String conjunction = "";
    private List<MediaCriteria.QUERY_ORDER_BY> logicalOrderBy;
    private boolean distinct = false;
    private int resultLimit = 0;

    private MediaSQLQueryBuilder(boolean count) {
        this.count = count;
    }

    static MediaSQLQueryBuilder selectBuilder() {
        return new MediaSQLQueryBuilder(false);
    }

    static MediaSQLQueryBuilder countBuilder() {
        return new MediaSQLQueryBuilder(true);
    }

    @Override
    public void startProcessing() {
        if (!this.count) {
            this.sqlQuery.append("select M.mediaId, M.mediaType, M.instanceId").append(", M.title, M.description, M.author, M.keyWord").append(", M.beginVisibilityDate, M.endVisibilityDate").append(", M.createDate, M.createdBy, M.lastUpdateDate, M.lastUpdatedBy ");
        } else {
            this.sqlQuery.append("select count(M.mediaId) ");
        }
        this.from.append("from SC_Gallery_Media M ");
    }

    @Override
    public void endProcessing() {
        if (this.distinct) {
            this.sqlQuery.insert(this.count ? 13 : 7, "distinct ");
        }
        this.sqlQuery.append(this.from.toString());
        if (this.where.length() > 0) {
            this.sqlQuery.append(" where ").append(this.where.toString());
        }
        if (this.orderBy != null && this.orderBy.length() > 0) {
            this.sqlQuery.append(this.orderBy.toString());
        }
        this.done = true;
    }

    public JdbcSqlQuery result() {
        return JdbcSqlQuery.create((String)this.sqlQuery.toString(), this.parameters).configure(config -> config.withResultLimit(this.resultLimit));
    }

    @Override
    public MediaCriteriaProcessor then() {
        if (!this.done) {
            this.conjunction = " and ";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processResultLimit(int resultLimit) {
        this.resultLimit = resultLimit;
        return this;
    }

    @Override
    public MediaCriteriaProcessor processVisibility(MediaCriteria.VISIBILITY visibility, Date dateReference, UserDetail creator) {
        switch (visibility) {
            case VISIBLE_ONLY: 
            case HIDDEN_ONLY: 
            case BY_DEFAULT: {
                this.setVisibilityClause(visibility, dateReference, creator);
                break;
            }
        }
        this.conjunction = "";
        return this;
    }

    private void setVisibilityClause(MediaCriteria.VISIBILITY visibility, Date dateReference, UserDetail creator) {
        StringBuilder clause;
        if (visibility == MediaCriteria.VISIBILITY.HIDDEN_ONLY) {
            clause = this.where(this.conjunction).append("((? < M.beginVisibilityDate or ? > M.endVisibilityDate)");
            this.parameters.add(dateReference.getTime());
            this.parameters.add(dateReference.getTime());
        } else {
            clause = this.where(this.conjunction).append("((? between M.beginVisibilityDate and M.endVisibilityDate)");
            this.parameters.add(dateReference.getTime());
        }
        if (creator != null) {
            clause.append(" or M.createdBy = ?");
            this.parameters.add(creator.getId());
        }
        clause.append(")");
    }

    @Override
    public MediaCriteriaProcessor processComponentInstance(String componentInstanceId) {
        if (!this.done) {
            this.where(this.conjunction).append("M.instanceId = ?");
            this.parameters.add(componentInstanceId);
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processAlbums(List<String> albumIds) {
        if (!this.done) {
            StringBuilder params = new StringBuilder();
            for (String albumId : albumIds) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
                this.parameters.add(Integer.valueOf(albumId));
            }
            this.distinct = true;
            this.from.append("join SC_Gallery_Path A on M.mediaId = A.mediaId and M.instanceId = A.instanceId ");
            this.where(this.conjunction).append("A.nodeId in (").append(params.toString()).append(")");
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processCreator(UserDetail creator) {
        if (!this.done) {
            this.where(this.conjunction).append("M.createdBy = ?");
            this.parameters.add(creator.getId());
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processMediaTypes(List<MediaType> mediaTypes) {
        if (!this.done) {
            StringBuilder params = new StringBuilder();
            for (MediaType mediaType : mediaTypes) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
                this.parameters.add(mediaType.name());
            }
            this.where(this.conjunction).append("M.mediaType in (").append(params.toString()).append(")");
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processNbDaysBeforeThatMediaIsNotVisible(Date referenceDate, int nbDaysBeforeThatMediaIsNotVisible) {
        if (!this.done) {
            this.where(this.conjunction).append("M.endVisibilityDate between ? and ?");
            DateTime date = new DateTime(DateUtils.addDays((Date)referenceDate, (int)nbDaysBeforeThatMediaIsNotVisible));
            this.parameters.add(((DateTime)date.getBeginOfDay()).getTime());
            this.parameters.add(((DateTime)date.getEndOfDay()).getTime());
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processOrdering(List<MediaCriteria.QUERY_ORDER_BY> orderings) {
        if (!this.done) {
            for (MediaCriteria.QUERY_ORDER_BY anOrdering : orderings) {
                if (!anOrdering.isApplicableOnSQLQuery()) {
                    this.logicalOrderBy = orderings;
                    this.orderBy = null;
                    break;
                }
                if (this.orderBy == null) {
                    this.orderBy = new StringBuilder(" order by ");
                } else {
                    this.orderBy.append(", ");
                }
                this.orderBy.append(anOrdering.getInstructionBase());
                this.orderBy.append(" ");
                this.orderBy.append(anOrdering.isAsc() ? "asc" : "desc");
            }
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public MediaCriteriaProcessor processIdentifiers(List<String> identifiers) {
        if (!this.done) {
            StringBuilder params = new StringBuilder();
            for (String identifier : identifiers) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
                this.parameters.add(identifier);
            }
            this.where(this.conjunction).append("M.mediaId in (").append(params.toString()).append(")");
            this.conjunction = "";
        }
        return this;
    }

    @Override
    public List<Media> orderingResult(List<Media> media) {
        if (CollectionUtil.isNotEmpty(this.logicalOrderBy)) {
            Collections.sort(media, MediaLogicalComparator.on(this.logicalOrderBy));
        }
        return media;
    }

    private StringBuilder where(String conjunction) {
        if (this.where.length() > 0) {
            this.where.append(conjunction);
        }
        return this.where;
    }
}

