/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.socialnetwork;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialMediaProvider;
import org.silverpeas.core.util.ServiceProvider;

@Provider
public class SocialGalleryMedia
implements SocialMediaProvider {
    protected SocialGalleryMedia() {
    }

    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        return this.getGalleryService().getAllMediaByUserId(userId, Period.from((Date)begin, (Date)end));
    }

    public List<SocialInformation> getSocialInformationListOfMyContacts(String userId, List<String> myContactsIds, Date begin, Date end) {
        List<SocialInformation> listSocialInfo = new ArrayList<SocialInformation>();
        List<String> listComponents = this.getListAvailable(userId);
        if (!listComponents.isEmpty()) {
            listSocialInfo = this.getGalleryService().getSocialInformationListOfMyContacts(myContactsIds, listComponents, Period.from((Date)begin, (Date)end));
        }
        return listSocialInfo;
    }

    private GalleryService getGalleryService() {
        return (GalleryService)ServiceProvider.getService(GalleryService.class, (Annotation[])new Annotation[0]);
    }

    private List<String> getListAvailable(String userId) {
        List availableList = OrganizationControllerProvider.getOrganisationController().getAvailComponentInstLights(userId, "gallery");
        ArrayList<String> idsList = new ArrayList<String>(availableList.size());
        for (ComponentInstLight comp : availableList) {
            idsList.add(comp.getId());
        }
        return idsList;
    }
}

