/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import javax.inject.Named;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.FormsOnlineService;
import org.silverpeas.components.formsonline.notification.FormsOnlineUserAlertNotification;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;

@Named
public class FormsOnlineInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    private static final String FORM_KEY = "FormDetailKey";

    protected boolean check(NotificationContext context) {
        String formId = context.getContributionId();
        String instanceId = context.getComponentId();
        try {
            FormDetail form = FormsOnlineService.get().loadForm(new FormPK(formId, instanceId));
            context.put((Object)FORM_KEY, (Object)form);
            return form.isPublished();
        }
        catch (FormsOnlineException e) {
            return false;
        }
    }

    public UserNotification createUserNotification(NotificationContext context) {
        FormDetail form = (FormDetail)context.getObject((Object)FORM_KEY);
        context.put((Object)"publicationId", (Object)form.getId());
        return new FormsOnlineUserAlertNotification(form, context.getSender()).build();
    }
}

