/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.PaginationList;
import org.silverpeas.core.util.Pair;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;

public class RequestsByStatus {
    private static final Comparator<FormInstance> FORM_INSTANCE_COMPARATOR = (a, b) -> {
        int c = b.getCreationDate().compareTo(a.getCreationDate());
        if (c == 0) {
            c = b.getIdAsInt() - a.getIdAsInt();
        }
        return c;
    };
    static final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> toValidateCriteriaConfigurer = (f, t) -> {
        t.andAvoidValidatedByValidator();
        Set possibleFormValidationTypes = (Set)f.getFirst();
        Set<FormInstanceValidationType> possibleValidatorValidationTypes = ((Set)f.getSecond()).stream().filter(possibleFormValidationTypes::contains).collect(Collectors.toSet());
        RequestsByStatus.setLastValidationTypeCriteria(possibleFormValidationTypes, possibleValidatorValidationTypes, t);
        boolean isHierarchicalFormValidation = possibleFormValidationTypes.contains((Object)FormInstanceValidationType.HIERARCHICAL);
        if (isHierarchicalFormValidation) {
            if (possibleValidatorValidationTypes.contains((Object)FormInstanceValidationType.HIERARCHICAL)) {
                t.orValidatorIsHierarchicalOne();
            }
        } else if (possibleValidatorValidationTypes.stream().filter(v -> v != FormInstanceValidationType.HIERARCHICAL).anyMatch(v -> possibleFormValidationTypes.stream().findFirst().filter(p -> p == v).isPresent())) {
            t.orNoValidator();
        }
    };
    static final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> concernedByValidationCriteriaConfigurer = (f, t) -> {
        Set possibleFormValidationTypes = (Set)f.getFirst();
        boolean isLastValidatorCase = RequestsByStatus.isLastValidatorCase(possibleFormValidationTypes, (Set)f.getSecond());
        if (isLastValidatorCase) {
            toValidateCriteriaConfigurer.accept((Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>)f, (RequestValidationCriteria)t);
            t.invert();
        } else {
            t.andStillNeedValidation();
            RequestsByStatus.setLastValidationTypeCriteria(possibleFormValidationTypes, possibleFormValidationTypes, t);
        }
    };
    static final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> skipValidationCriteriaIfLastValidatorConfigurer = (f, t) -> {
        if (RequestsByStatus.isLastValidatorCase((Set)f.getFirst(), (Set)f.getSecond())) {
            t.skipValidationFiltering();
        }
    };
    static final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> canceledCriteriaConfigurer = (f, t) -> {
        skipValidationCriteriaIfLastValidatorConfigurer.accept((Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>)f, (RequestValidationCriteria)t);
        if (!t.isSkipValidationFiltering()) {
            t.orNoValidator();
        }
    };
    static final List<MergeRuleByStates> MERGING_RULES_BY_STATES = Arrays.asList(new MergeRuleByStates(Collections.singletonList(0), RequestsByStatus::addDraft), new MergeRuleByStates(Collections.singletonList(4), RequestsByStatus::addDenied), new MergeRuleByStates(Collections.singletonList(3), RequestsByStatus::addValidated), new MergeRuleByStates(Collections.singletonList(5), RequestsByStatus::addArchived), new MergeRuleByStates(Collections.singletonList(6), RequestsByStatus::addCanceled), new MergeRuleByStates(Arrays.asList(1, 2), RequestsByStatus::addToValidate));
    static final List<ValidationMergeRuleByStates> VALIDATION_MERGING_RULES_BY_STATES = Arrays.asList(new ValidationMergeRuleByStates(Collections.singletonList(4), skipValidationCriteriaIfLastValidatorConfigurer, RequestsByStatus::addDenied), new ValidationMergeRuleByStates(Collections.singletonList(3), skipValidationCriteriaIfLastValidatorConfigurer, RequestsByStatus::addValidated), new ValidationMergeRuleByStates(Collections.singletonList(5), skipValidationCriteriaIfLastValidatorConfigurer, RequestsByStatus::addArchived), new ValidationMergeRuleByStates(Collections.singletonList(6), canceledCriteriaConfigurer, RequestsByStatus::addCanceled), new ValidationMergeRuleByStates(Arrays.asList(1, 2), toValidateCriteriaConfigurer, RequestsByStatus::addToValidate), new ValidationMergeRuleByStates(Arrays.asList(1, 2), concernedByValidationCriteriaConfigurer, RequestsByStatus::addConcernedByValidation));
    private final PaginationPage paginationPage;
    private SilverpeasList<FormInstance> draftList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> toValidateList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> concernedByValidationList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> validatedList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> deniedList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> archivedList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> canceledList = new SilverpeasArrayList();
    private SilverpeasList<FormInstance> all = null;

    RequestsByStatus(PaginationPage paginationPage) {
        this.paginationPage = paginationPage;
    }

    private static void setLastValidationTypeCriteria(Set<FormInstanceValidationType> possibleFormValidationTypes, Set<FormInstanceValidationType> possibleValidatorValidationTypes, RequestValidationCriteria criteria) {
        TreeSet<FormInstanceValidationType> lastValidationFilter = new TreeSet<FormInstanceValidationType>();
        possibleValidatorValidationTypes.stream().filter(v -> v != FormInstanceValidationType.HIERARCHICAL).forEach(v -> Stream.of(FormInstanceValidationType.values()).sorted(Comparator.reverseOrder()).filter(l -> l.ordinal() < v.ordinal()).filter(possibleFormValidationTypes::contains).findFirst().ifPresent(lastValidationFilter::add));
        criteria.orLastValidationType(lastValidationFilter);
    }

    private static boolean isLastValidatorCase(Set<FormInstanceValidationType> possibleFormValidationTypes, Set<FormInstanceValidationType> possibleValidatorValidationTypes) {
        return possibleValidatorValidationTypes.stream().filter(possibleFormValidationTypes::contains).max(Comparator.naturalOrder()).filter(v -> possibleFormValidationTypes.stream().max(Comparator.naturalOrder()).orElse(null) == v).isPresent();
    }

    public static Set<FormInstanceValidationType> possibleRequestValidationsFrom(Collection<FormInstance> requests) {
        return requests.stream().map(FormInstance::getForm).distinct().flatMap(f -> f.getPossibleRequestValidations().keySet().stream()).collect(Collectors.toCollection(TreeSet::new));
    }

    private void addDraft(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.draftList = this.merge(formInstances, this.draftList);
    }

    private void addArchived(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.archivedList = this.merge(formInstances, this.archivedList);
    }

    private void addDenied(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.deniedList = this.merge(formInstances, this.deniedList);
    }

    private void addValidated(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.validatedList = this.merge(formInstances, this.validatedList);
    }

    private void addToValidate(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.toValidateList = this.merge(formInstances, this.toValidateList);
    }

    private void addConcernedByValidation(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.concernedByValidationList = this.merge(formInstances, this.concernedByValidationList);
    }

    private void addCanceled(SilverpeasList<FormInstance> formInstances) {
        this.resetAll();
        this.canceledList = this.merge(formInstances, this.canceledList);
    }

    public SilverpeasList<FormInstance> getDraft() {
        return this.draftList;
    }

    public SilverpeasList<FormInstance> getToValidate() {
        return this.toValidateList;
    }

    public SilverpeasList<FormInstance> getConcernedByValidation() {
        return this.concernedByValidationList;
    }

    public SilverpeasList<FormInstance> getDenied() {
        return this.deniedList;
    }

    public SilverpeasList<FormInstance> getValidated() {
        return this.validatedList;
    }

    public SilverpeasList<FormInstance> getArchived() {
        return this.archivedList;
    }

    public SilverpeasList<FormInstance> getCanceled() {
        return this.canceledList;
    }

    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    public SilverpeasList<FormInstance> getAll() {
        if (this.all == null) {
            this.all = this.merge(this.getDraft(), this.getToValidate(), this.getConcernedByValidation(), this.getValidated(), this.getDenied(), this.getArchived(), this.getCanceled());
        }
        return this.all;
    }

    private void resetAll() {
        this.all = null;
    }

    @SafeVarargs
    private final SilverpeasList<FormInstance> merge(SilverpeasList<FormInstance> ... lists) {
        int size = 0;
        long maxSize = 0L;
        for (SilverpeasList<FormInstance> list : lists) {
            size += list.size();
            maxSize += list.originalListSize();
        }
        HashMap<String, FormInstance> merge = new HashMap<String, FormInstance>(size);
        for (SilverpeasList<FormInstance> list : lists) {
            for (FormInstance formInstance : list) {
                merge.putIfAbsent(formInstance.getId(), formInstance);
            }
        }
        Stream<FormInstance> resultStream = merge.values().stream().sorted(FORM_INSTANCE_COMPARATOR);
        if (this.paginationPage != null) {
            resultStream = resultStream.limit(this.paginationPage.getPageSize());
        }
        return PaginationList.from((Collection)resultStream.collect(Collectors.toList()), (long)(maxSize - (long)(size - merge.values().size())));
    }

    public static class ValidationMergeRuleByStates
    extends MergeRuleByStates {
        private final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> validationCriteriaConfigurer;

        public ValidationMergeRuleByStates(List<Integer> states, BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> validationCriteriaConfigurer, BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> merger) {
            super(states, merger);
            this.validationCriteriaConfigurer = validationCriteriaConfigurer;
        }

        public BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> getValidationCriteriaConfigurer() {
            return this.validationCriteriaConfigurer;
        }
    }

    public static class MergeRuleByStates {
        private final List<Integer> states;
        private final BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> merger;

        public MergeRuleByStates(List<Integer> states, BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> merger) {
            this.states = states;
            this.merger = merger;
        }

        public List<Integer> getStates() {
            return this.states;
        }

        public BiConsumer<RequestsByStatus, SilverpeasList<FormInstance>> getMerger() {
            return this.merger;
        }
    }
}

