/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.rssaggregator.service;

import java.util.List;
import org.silverpeas.components.rssaggregator.model.RssAgregatorException;
import org.silverpeas.components.rssaggregator.model.SPChannel;
import org.silverpeas.components.rssaggregator.model.SPChannelPK;
import org.silverpeas.components.rssaggregator.service.RssAggregator;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanIntf;

@Service
public class DefaultRssAggregator
implements RssAggregator {
    private static final String SYNDICATION_CHANNEL_WITH_ID = "syndication channel with id";
    private SilverpeasBeanDAO<SPChannel> rssDAO;

    @Override
    public SPChannel addChannel(SPChannel channel) throws RssAgregatorException {
        try {
            WAPrimaryKey pk = this.getDAO().add((SilverpeasBeanIntf)channel);
            channel.setPK(pk);
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnAdding((String)"syndication channel at", (Object)channel.getUrl()), e);
        }
        return channel;
    }

    @Override
    public void deleteChannel(SPChannelPK channelPK) throws RssAgregatorException {
        try {
            this.getDAO().remove((WAPrimaryKey)channelPK);
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnDeleting((String)SYNDICATION_CHANNEL_WITH_ID, (Object)channelPK.getId()), e);
        }
    }

    @Override
    public List<SPChannel> getChannels(String instanceId) throws RssAgregatorException {
        List channels;
        try {
            SPChannelPK pk = new SPChannelPK("useless", instanceId);
            channels = (List)this.getDAO().findByWhereClause((WAPrimaryKey)pk, "instanceId = '" + instanceId + "' ORDER BY id");
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnGetting((String)"syndication channels of component instance", (Object)instanceId), e);
        }
        return channels;
    }

    @Override
    public void deleteChannels(String instanceId) throws RssAgregatorException {
        try {
            SPChannelPK pk = new SPChannelPK("useless", instanceId);
            this.getDAO().removeWhere((WAPrimaryKey)pk, "instanceId = '" + instanceId + "'");
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnDeleting((String)"syndication channels of component instance", (Object)instanceId), e);
        }
    }

    @Override
    public void updateChannel(SPChannel channel) throws RssAgregatorException {
        try {
            this.getDAO().update((SilverpeasBeanIntf)channel);
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnAdding((String)SYNDICATION_CHANNEL_WITH_ID, (Object)channel.getPK().getId()), e);
        }
    }

    private SilverpeasBeanDAO<SPChannel> getDAO() throws RssAgregatorException {
        if (this.rssDAO == null) {
            try {
                this.rssDAO = SilverpeasBeanDAOFactory.getDAO((String)SPChannel.class.getName());
            }
            catch (PersistenceException e) {
                throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnGetting((String)"DAO for syndication channels", (Object)""), e);
            }
        }
        return this.rssDAO;
    }

    @Override
    public SPChannel getChannel(SPChannelPK channelPK) throws RssAgregatorException {
        SPChannel channel;
        try {
            channel = (SPChannel)this.getDAO().findByPrimaryKey((WAPrimaryKey)channelPK);
        }
        catch (PersistenceException e) {
            throw new RssAgregatorException(SilverpeasExceptionMessages.failureOnGetting((String)SYNDICATION_CHANNEL_WITH_ID, (Object)channelPK.getId()), e);
        }
        return channel;
    }
}

