/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.combined;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CombinedEditor
implements AccessControlEditor {
    private static Logger log = LoggerFactory.getLogger(CombinedEditor.class);
    private final AccessControlEditor[] editors;

    CombinedEditor(AccessControlEditor[] editors) {
        this.editors = editors;
    }

    @Override
    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> templates = new ArrayList<AccessControlPolicy>();
        for (AccessControlEditor editor : this.editors) {
            AccessControlPolicy[] ts = editor.getPolicies(nodePath);
            if (ts == null || ts.length <= 0) continue;
            templates.addAll(Arrays.asList(ts));
        }
        return templates.toArray(new AccessControlPolicy[templates.size()]);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessControlException, RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> templates = new ArrayList<JackrabbitAccessControlPolicy>();
        for (AccessControlEditor editor : this.editors) {
            JackrabbitAccessControlPolicy[] ts = editor.getPolicies(principal);
            if (ts == null || ts.length <= 0) continue;
            templates.addAll(Arrays.asList(ts));
        }
        return templates.toArray(new JackrabbitAccessControlPolicy[templates.size()]);
    }

    @Override
    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> templates = new ArrayList<AccessControlPolicy>();
        for (AccessControlEditor editor : this.editors) {
            try {
                templates.addAll(Arrays.asList(editor.editAccessControlPolicies(nodePath)));
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        return templates.toArray(new AccessControlPolicy[templates.size()]);
    }

    @Override
    public JackrabbitAccessControlPolicy[] editAccessControlPolicies(Principal principal) throws RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> templates = new ArrayList<JackrabbitAccessControlPolicy>();
        for (AccessControlEditor editor : this.editors) {
            try {
                templates.addAll(Arrays.asList(editor.editAccessControlPolicies(principal)));
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        return templates.toArray(new JackrabbitAccessControlPolicy[templates.size()]);
    }

    @Override
    public void setPolicy(String nodePath, AccessControlPolicy template) throws AccessControlException, PathNotFoundException, RepositoryException {
        for (AccessControlEditor editor : this.editors) {
            try {
                editor.setPolicy(nodePath, template);
                log.debug("Set template " + template + " using " + editor);
                return;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        throw new AccessControlException("None of the editors accepted policy " + template + " at " + nodePath);
    }

    @Override
    public void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        for (AccessControlEditor editor : this.editors) {
            try {
                editor.removePolicy(nodePath, policy);
                log.debug("Removed template " + policy + " using " + editor);
                return;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        throw new AccessControlException("Unable to remove template " + policy);
    }
}

