/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.RedoLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Recovery {
    private static final Logger log = LoggerFactory.getLogger(Recovery.class);
    private final MultiIndex index;
    private final RedoLog redoLog;
    private final Set<Long> losers = new HashSet<Long>();

    private Recovery(MultiIndex index, RedoLog redoLog) {
        this.index = index;
        this.redoLog = redoLog;
    }

    static void run(MultiIndex index, RedoLog redoLog) throws IOException {
        if (!redoLog.hasEntries()) {
            log.debug("RedoLog is empty, no recovery needed.");
            return;
        }
        log.info("Found uncommitted redo log. Applying changes now...");
        Recovery r = new Recovery(index, redoLog);
        r.run();
        log.info("Redo changes applied.");
    }

    private void run() throws IOException {
        MultiIndex.Action a;
        int i;
        List<MultiIndex.Action> actions = this.redoLog.getActions();
        for (MultiIndex.Action a2 : actions) {
            if (a2.getType() == 0) {
                this.losers.add(a2.getTransactionId());
                continue;
            }
            if (a2.getType() != 3) continue;
            this.losers.remove(a2.getTransactionId());
        }
        int lastSafeVolatileCommit = -1;
        HashSet<Long> transactionIds = new HashSet<Long>();
        for (i = 0; i < actions.size(); ++i) {
            a = actions.get(i);
            if (a.getType() == 3) {
                transactionIds.clear();
                continue;
            }
            if (a.getType() == 4) {
                transactionIds.retainAll(this.losers);
                if (transactionIds.size() > 0) break;
                lastSafeVolatileCommit = i;
                continue;
            }
            transactionIds.add(a.getTransactionId());
        }
        for (i = lastSafeVolatileCommit + 1; i < actions.size(); ++i) {
            a = actions.get(i);
            if (a.getType() != 5) continue;
            a.undo(this.index);
        }
        block6: for (i = 0; i < actions.size() && i <= lastSafeVolatileCommit; ++i) {
            a = actions.get(i);
            switch (a.getType()) {
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    if (a.getTransactionId() == -2L) continue block6;
                    a.execute(this.index);
                }
            }
        }
        for (i = lastSafeVolatileCommit + 1; i < actions.size() && !this.losers.contains(new Long((a = actions.get(i)).getTransactionId())); ++i) {
            if (a.getTransactionId() == -2L) continue;
            a.execute(this.index);
        }
        this.index.safeFlush();
    }
}

