/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.dao;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.silverpeas.components.whitepages.dao.SearchFieldDao;
import org.silverpeas.components.whitepages.model.SearchField;
import org.silverpeas.core.annotation.Repository;

@Repository
@Named(value="searchFieldDao")
@Transactional
public class SearchFieldDaoImpl
implements SearchFieldDao {
    @PersistenceContext
    private EntityManager theEntityManager;

    private EntityManager getEntityManager() {
        return this.theEntityManager;
    }

    @Override
    public String createSearchField(SearchField searchField) {
        this.getEntityManager().persist((Object)searchField);
        return searchField.getId();
    }

    @Override
    public void deleteSearchFieldsFor(String instanceId) {
        EntityManager entityManager = this.getEntityManager();
        Set<SearchField> returnSet = this.getSearchFields(instanceId);
        if (returnSet != null && !returnSet.isEmpty()) {
            for (SearchField searchField : returnSet) {
                entityManager.remove((Object)searchField);
            }
        }
    }

    @Override
    public Set<SearchField> getSearchFields(String instanceId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("whitepages.findByInstanceId", SearchField.class);
        query.setParameter("instanceId", (Object)instanceId);
        return new HashSet<SearchField>(query.getResultList());
    }
}

