/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.model;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.suggestionbox.SuggestionBoxComponentSettings;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.model.SuggestionBoxService;
import org.silverpeas.components.suggestionbox.repository.SuggestionBoxRepository;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.SettingBundle;

@Service
@Named(value="suggestionBoxService")
public class DefaultSuggestionBoxService
implements SuggestionBoxService {
    @Inject
    private SuggestionBoxRepository suggestionBoxRepository;

    @Override
    public SuggestionBox getByComponentInstanceId(String componentInstanceId) {
        return this.suggestionBoxRepository.getByComponentInstanceId(componentInstanceId);
    }

    @Override
    public void indexSuggestionBox(SuggestionBox suggestionBox) {
        suggestionBox.getSuggestions().index();
    }

    @Override
    @Transactional
    public void saveSuggestionBox(SuggestionBox box) {
        this.suggestionBoxRepository.save((IdentifiableEntity)box);
    }

    @Override
    @Transactional
    public void deleteSuggestionBox(SuggestionBox box) {
        this.suggestionBoxRepository.delete((IdentifiableEntity[])new SuggestionBox[]{box});
        this.suggestionBoxRepository.flush();
        AttachmentService attachmentService = AttachmentServiceProvider.getAttachmentService();
        attachmentService.deleteAllAttachments(box.getComponentInstanceId());
        RatingService.get().deleteComponentRatings(box.getComponentInstanceId());
    }

    @Override
    public Optional<Suggestion> getContributionById(ContributionIdentifier contributionId) {
        return Optional.of(Suggestion.getById(contributionId.getLocalId()));
    }

    public SettingBundle getComponentSettings() {
        return SuggestionBoxComponentSettings.getSettings();
    }

    public LocalizationBundle getComponentMessages(String language) {
        return SuggestionBoxComponentSettings.getMessagesIn(language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("suggestionBox");
    }
}

