/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import org.odftoolkit.odfdom.dom.element.draw.DrawFillImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawHatchElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMarkerElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextOutlineStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfOfficeStyles
extends OfficeStylesElement {
    private static final long serialVersionUID = 700763983193326060L;
    private HashMap<OdfStyleFamily, OdfDefaultStyle> mDefaultStyles;
    private HashMap<String, DrawMarkerElement> mMarker;
    private HashMap<String, DrawGradientElement> mGradients;
    private HashMap<String, DrawHatchElement> mHatches;
    private HashMap<String, DrawFillImageElement> mFillImages;
    private OdfTextOutlineStyle mOutlineStyle;
    private OdfStylesBase mStylesBaseImpl = new OdfStylesBase();

    public OdfOfficeStyles(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfStyle newStyle(String name, OdfStyleFamily family) {
        OdfStyle newStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(OdfStyle.class);
        newStyle.setStyleNameAttribute(name);
        newStyle.setStyleFamilyAttribute(family.getName());
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfDefaultStyle getOrCreateDefaultStyle(OdfStyleFamily family) {
        OdfDefaultStyle style = this.getDefaultStyle(family);
        if (style == null) {
            style = ((OdfFileDom)this.ownerDocument).newOdfElement(OdfDefaultStyle.class);
            style.setStyleFamilyAttribute(family.getName());
            this.appendChild((Node)((Object)style));
        }
        return style;
    }

    public OdfTextListStyle newListStyle(String name) {
        OdfTextListStyle newStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(OdfTextListStyle.class);
        newStyle.setStyleNameAttribute(name);
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfTextOutlineStyle getOrCreateOutlineStyle() {
        if (this.mOutlineStyle == null) {
            this.appendChild((Node)((Object)((OdfFileDom)this.ownerDocument).newOdfElement(OdfTextOutlineStyle.class)));
        }
        return this.mOutlineStyle;
    }

    public OdfTextOutlineStyle getOutlineStyle() {
        return this.mOutlineStyle;
    }

    public OdfDefaultStyle getDefaultStyle(OdfStyleFamily familyType) {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.get(familyType);
        }
        return null;
    }

    public Iterable<OdfDefaultStyle> getDefaultStyles() {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.values();
        }
        return new ArrayList<OdfDefaultStyle>();
    }

    public DrawMarkerElement getMarker(String name) {
        if (this.mMarker != null) {
            return this.mMarker.get(name);
        }
        return null;
    }

    public Iterable<DrawMarkerElement> getMarker() {
        if (this.mMarker != null) {
            return this.mMarker.values();
        }
        return new ArrayList<DrawMarkerElement>();
    }

    public DrawGradientElement getGradient(String name) {
        if (this.mGradients != null) {
            return this.mGradients.get(name);
        }
        return null;
    }

    public Iterable<DrawGradientElement> getGradients() {
        if (this.mGradients != null) {
            return this.mGradients.values();
        }
        return new ArrayList<DrawGradientElement>();
    }

    public DrawHatchElement getHatch(String name) {
        if (this.mHatches != null) {
            return this.mHatches.get(name);
        }
        return null;
    }

    public Iterable<DrawHatchElement> getHatches() {
        if (this.mHatches != null) {
            return this.mHatches.values();
        }
        return new ArrayList<DrawHatchElement>();
    }

    public DrawFillImageElement getFillImage(String name) {
        if (this.mFillImages != null) {
            return this.mFillImages.get(name);
        }
        return null;
    }

    public Iterable<DrawFillImageElement> getFillImages() {
        if (this.mFillImages != null) {
            return this.mFillImages.values();
        }
        return new ArrayList<DrawFillImageElement>();
    }

    public OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStyle(name, familyType);
    }

    public Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStylesForFamily(familyType);
    }

    public OdfTextListStyle getListStyle(String name) {
        return this.mStylesBaseImpl.getListStyle(name);
    }

    public Iterable<OdfTextListStyle> getListStyles() {
        return this.mStylesBaseImpl.getListStyles();
    }

    public OdfNumberStyle getNumberStyle(String name) {
        return this.mStylesBaseImpl.getNumberStyle(name);
    }

    public Iterable<OdfNumberStyle> getNumberStyles() {
        return this.mStylesBaseImpl.getNumberStyles();
    }

    public OdfNumberDateStyle getDateStyle(String name) {
        return this.mStylesBaseImpl.getDateStyle(name);
    }

    public Iterable<OdfNumberDateStyle> getDateStyles() {
        return this.mStylesBaseImpl.getDateStyles();
    }

    public OdfNumberPercentageStyle getPercentageStyle(String name) {
        return this.mStylesBaseImpl.getPercentageStyle(name);
    }

    public Iterable<OdfNumberPercentageStyle> getPercentageStyles() {
        return this.mStylesBaseImpl.getPercentageStyles();
    }

    public OdfNumberCurrencyStyle getCurrencyStyle(String name) {
        return this.mStylesBaseImpl.getCurrencyStyle(name);
    }

    public Iterable<OdfNumberCurrencyStyle> getCurrencyStyles() {
        return this.mStylesBaseImpl.getCurrencyStyles();
    }

    public OdfNumberTimeStyle getTimeStyle(String name) {
        return this.mStylesBaseImpl.getTimeStyle(name);
    }

    public Iterable<OdfNumberTimeStyle> getTimeStyles() {
        return this.mStylesBaseImpl.getTimeStyles();
    }

    public NumberBooleanStyleElement getBooleanStyle(String name) {
        return this.mStylesBaseImpl.getBooleanStyle(name);
    }

    public Iterable<NumberBooleanStyleElement> getBooleanStyles() {
        return this.mStylesBaseImpl.getBooleanStyles();
    }

    public NumberTextStyleElement getTextStyle(String name) {
        return this.mStylesBaseImpl.getTextStyle(name);
    }

    public Iterable<NumberTextStyleElement> getTextStyles() {
        return this.mStylesBaseImpl.getTextStyles();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfDefaultStyle) {
            OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
            if (this.mDefaultStyles == null) {
                this.mDefaultStyles = new HashMap();
            }
            this.mDefaultStyles.put(defaultStyle.getFamily(), defaultStyle);
        } else if (node instanceof DrawMarkerElement) {
            DrawMarkerElement marker = (DrawMarkerElement)node;
            if (this.mMarker == null) {
                this.mMarker = new HashMap();
            }
            this.mMarker.put(marker.getDrawNameAttribute(), marker);
        } else if (node instanceof DrawGradientElement) {
            DrawGradientElement gradient = (DrawGradientElement)node;
            if (this.mGradients == null) {
                this.mGradients = new HashMap();
            }
            this.mGradients.put(gradient.getDrawNameAttribute(), gradient);
        } else if (node instanceof DrawHatchElement) {
            DrawHatchElement hatch = (DrawHatchElement)node;
            if (this.mHatches == null) {
                this.mHatches = new HashMap();
            }
            this.mHatches.put(hatch.getDrawNameAttribute(), hatch);
        } else if (node instanceof DrawFillImageElement) {
            DrawFillImageElement fillImage = (DrawFillImageElement)node;
            if (this.mFillImages == null) {
                this.mFillImages = new HashMap();
            }
            this.mFillImages.put(fillImage.getDrawNameAttribute(), fillImage);
        } else if (node instanceof OdfTextOutlineStyle) {
            this.mOutlineStyle = (OdfTextOutlineStyle)node;
        } else {
            this.mStylesBaseImpl.onOdfNodeInserted(node, refNode);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfDefaultStyle) {
            if (this.mDefaultStyles != null) {
                OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
                this.mDefaultStyles.remove(defaultStyle.getFamily());
            }
        } else if (node instanceof DrawMarkerElement) {
            if (this.mMarker != null) {
                DrawMarkerElement marker = (DrawMarkerElement)node;
                this.mMarker.remove(marker.getDrawNameAttribute());
            }
        } else if (node instanceof DrawGradientElement) {
            if (this.mGradients != null) {
                DrawGradientElement gradient = (DrawGradientElement)node;
                this.mGradients.remove(gradient.getDrawNameAttribute());
            }
        } else if (node instanceof DrawHatchElement) {
            if (this.mHatches != null) {
                DrawHatchElement hatch = (DrawHatchElement)node;
                this.mHatches.remove(hatch.getDrawNameAttribute());
            }
        } else if (node instanceof DrawFillImageElement) {
            if (this.mFillImages != null) {
                DrawFillImageElement fillImage = (DrawFillImageElement)node;
                this.mFillImages.remove(fillImage.getDrawNameAttribute());
            }
        } else if (node instanceof OdfTextOutlineStyle) {
            if (this.mOutlineStyle == (OdfTextOutlineStyle)node) {
                this.mOutlineStyle = null;
            }
        } else {
            this.mStylesBaseImpl.onOdfNodeRemoved(node);
        }
    }
}

