/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.projectmanager.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.components.projectmanager.model.TaskResourceDetail;
import org.silverpeas.core.NotSupportedException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.TodoDetail;

public class TaskDetail
implements Serializable {
    private static final long serialVersionUID = -1211845237822053494L;
    public static final int IN_PROGRESS = 0;
    public static final int STOPPED = 1;
    public static final int CANCELLED = 2;
    public static final int COMPLETE = 3;
    public static final int IN_ALERT = 4;
    public static final int NOT_STARTED = 5;
    private static final String TYPE = "Task";
    private int id;
    private int mereId = -1;
    private int chrono;
    private String nom;
    private String description;
    private int organisateurId;
    private int responsableId;
    private float charge;
    private float consomme;
    private float raf;
    private int statut;
    private Date dateDebut;
    private Date dateFin;
    private String codeProjet;
    private String descriptionProjet;
    private int estDecomposee;
    private String instanceId;
    private String path = "/";
    private int previousTaskId = -1;
    private Collection<TaskResourceDetail> resources = null;
    private String responsableFullName;
    private String organisateurFullName;
    private String uiDateDebut;
    private String uiDateFin;
    private List<SimpleDocument> attachments = null;
    private boolean isUnfold = false;
    private int level = 0;
    private boolean updateAvailable = false;
    private boolean deletionAvailable = false;
    private String uiDateDebutPlus1;
    private String previousTaskName = null;

    public TaskDetail() {
    }

    public TaskDetail(int id, int mereId, int chrono, String nom, String description, int organisateurId, int responsableId, float charge, float consomme, float raf, int statut, Date dateDebut, Date dateFin, String codeProjet, String descriptionProjet, int estDecomposee, String instanceId, String path) {
        this.id = id;
        this.mereId = mereId;
        this.chrono = chrono;
        this.nom = nom;
        this.description = description;
        this.organisateurId = organisateurId;
        this.responsableId = responsableId;
        this.charge = charge;
        this.consomme = consomme;
        this.raf = raf;
        this.statut = statut;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.codeProjet = codeProjet;
        this.descriptionProjet = descriptionProjet;
        this.estDecomposee = estDecomposee;
        this.instanceId = instanceId;
        this.path = path;
        this.level = StringUtils.countMatches((CharSequence)this.path, (CharSequence)"/") - 2;
    }

    public int getAvancement() {
        return Math.round(this.consomme / (this.consomme + this.raf) * 100.0f);
    }

    public float getCharge() {
        return this.charge;
    }

    public int getChrono() {
        return this.chrono;
    }

    public String getCodeProjet() {
        return this.codeProjet;
    }

    public float getConsomme() {
        return this.consomme;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionProjet() {
        return this.descriptionProjet;
    }

    public int getEstDecomposee() {
        return this.estDecomposee;
    }

    public int getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getMereId() {
        return this.mereId;
    }

    public String getNom() {
        return this.nom;
    }

    public int getOrganisateurId() {
        return this.organisateurId;
    }

    public float getRaf() {
        return this.raf;
    }

    public int getResponsableId() {
        return this.responsableId;
    }

    public Collection<TaskResourceDetail> getResources() {
        return this.resources;
    }

    public void setResources(Collection<TaskResourceDetail> resources) {
        this.resources = resources;
    }

    public int getStatut() {
        return this.statut;
    }

    public void setCharge(float f) {
        this.charge = f;
    }

    public void setCharge(String f) {
        this.charge = f != null && f.length() > 0 ? Float.valueOf(f).floatValue() : 0.0f;
    }

    public void setChrono(int i) {
        this.chrono = i;
    }

    public void setCodeProjet(String i) {
        this.codeProjet = i != null && i.length() > 0 ? i : "-1";
    }

    public void setConsomme(float f) {
        this.consomme = f;
    }

    public void setConsomme(String f) {
        this.consomme = f != null && f.length() > 0 ? Float.valueOf(f).floatValue() : 0.0f;
    }

    public void setDateDebut(Date string) {
        this.dateDebut = string;
    }

    public void setDateFin(Date string) {
        this.dateFin = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDescriptionProjet(String string) {
        this.descriptionProjet = string;
    }

    public void setEstDecomposee(int i) {
        this.estDecomposee = i;
    }

    public void setId(int i) {
        this.id = i;
    }

    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public void setMereId(int i) {
        this.mereId = i;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public void setOrganisateurId(int i) {
        this.organisateurId = i;
    }

    public void setOrganisateurId(String s) {
        this.organisateurId = Integer.valueOf(s);
    }

    public void setRaf(float f) {
        this.raf = f;
    }

    public void setRaf(String f) {
        this.raf = f != null && f.length() > 0 ? Float.valueOf(f).floatValue() : 0.0f;
    }

    public void setResponsableId(int i) {
        this.responsableId = i;
    }

    public void setStatut(int i) {
        this.statut = i;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public TodoDetail toTodoDetail() {
        TodoDetail todo = new TodoDetail();
        todo.setComponentId(this.getInstanceId());
        todo.setSpaceId("useless");
        todo.setName(this.getNom());
        todo.setDescription(this.getDescription());
        todo.setDelegatorId(Integer.toString(this.getOrganisateurId()));
        Attendee attendee = new Attendee(String.valueOf(this.getResponsableId()));
        if (attendee != null) {
            ArrayList<Attendee> attendees = new ArrayList<Attendee>();
            attendees.add(attendee);
            todo.setAttendees(attendees);
        }
        todo.setExternalId(Integer.toString(this.getId()));
        todo.setStartDate(this.getDateDebut());
        todo.setEndDate(this.getDateFin());
        todo.setPercentCompleted(this.getAvancement());
        return todo;
    }

    public void setResourceIds(Collection<TaskResourceDetail> resources) {
        this.resources = resources;
    }

    public String getResponsableFullName() {
        return this.responsableFullName;
    }

    public void setResponsableFullName(String string) {
        this.responsableFullName = string;
    }

    public String getUiDateDebut() {
        return this.uiDateDebut;
    }

    public String getUiDateFin() {
        return this.uiDateFin;
    }

    public void setUiDateDebut(String string) {
        this.uiDateDebut = string;
    }

    public void setUiDateFin(String string) {
        this.uiDateFin = string;
    }

    public String getUiCodeProjet() {
        if (this.getCodeProjet().equals("-1")) {
            return "";
        }
        return this.getCodeProjet();
    }

    public String getUiDescriptionProjet() {
        if (this.getDescriptionProjet() == null) {
            return "";
        }
        return this.getDescriptionProjet();
    }

    public String getUiDescription() {
        if (this.getDescription() == null) {
            return "";
        }
        return this.getDescription();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TaskDetail {").append("\n");
        result.append("  id = ").append(this.getId()).append("\n");
        result.append("  mereId = ").append(this.getMereId()).append("\n");
        result.append("  chrono = ").append(this.getChrono()).append("\n");
        result.append("  nom = ").append(this.getNom()).append("\n");
        result.append("  organisateurId = ").append(this.getOrganisateurId()).append("\n");
        result.append("  responsableId = ").append(this.getResponsableId()).append("\n");
        result.append("  charge = ").append(this.getCharge()).append("\n");
        result.append("  consomme  = ").append(this.getConsomme()).append("\n");
        result.append("  raf = ").append(this.getRaf()).append("\n");
        result.append("  avancement  = ").append(this.getAvancement()).append("\n");
        result.append("  statut = ").append(this.getStatut()).append("\n");
        result.append("  dateDebut = ").append(this.getDateDebut()).append("\n");
        result.append("  dateFin = ").append(this.getDateFin()).append("\n");
        result.append("  codeProjet = ").append(this.getCodeProjet()).append("\n");
        result.append("  estDecomposee = ").append(this.getEstDecomposee()).append("\n");
        result.append("  instanceId = ").append(this.getInstanceId()).append("\n");
        result.append("  path = ").append(this.getPath()).append("\n");
        result.append("}");
        return result.toString();
    }

    public String getOrganisateurFullName() {
        return this.organisateurFullName;
    }

    public void setOrganisateurFullName(String string) {
        this.organisateurFullName = string;
    }

    public List<SimpleDocument> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<SimpleDocument> vector) {
        this.attachments = vector;
    }

    public boolean isUnfold() {
        return this.isUnfold;
    }

    public void setUnfold(boolean b) {
        this.isUnfold = b;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public boolean isDeletionAvailable() {
        return this.deletionAvailable;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public void setDeletionAvailable(boolean b) {
        this.deletionAvailable = b;
    }

    public void setUpdateAvailable(boolean b) {
        this.updateAvailable = b;
    }

    public int getPreviousTaskId() {
        return this.previousTaskId;
    }

    public void setPreviousTaskId(int i) {
        this.previousTaskId = i;
    }

    public String getUiDateDebutPlus1() {
        return this.uiDateDebutPlus1;
    }

    public void setUiDateDebutPlus1(String string) {
        this.uiDateDebutPlus1 = string;
    }

    public String getPreviousTaskName() {
        return this.previousTaskName;
    }

    public void setPreviousTaskName(String string) {
        this.previousTaskName = string;
    }

    public String getContributionType() {
        return TYPE;
    }

    public static String getResourceType() {
        return TYPE;
    }

    public Contribution asContribution() {
        return new TaskContribution(this);
    }

    private static class TaskContribution
    implements Contribution {
        private static final long serialVersionUID = -6909201682577518080L;
        private static final String NOT_SUPPORTED_MESSAGE = "TaskContribution is not a real Contribution for now";
        private final TaskDetail task;

        private TaskContribution(TaskDetail task) {
            this.task = task;
        }

        public ContributionIdentifier getIdentifier() {
            return ContributionIdentifier.from((String)this.task.getInstanceId(), (String)String.valueOf(this.task.getId()), (String)this.task.getContributionType());
        }

        public User getCreator() {
            throw new NotSupportedException(NOT_SUPPORTED_MESSAGE);
        }

        public Date getCreationDate() {
            throw new NotSupportedException(NOT_SUPPORTED_MESSAGE);
        }

        public User getLastUpdater() {
            throw new NotSupportedException(NOT_SUPPORTED_MESSAGE);
        }

        public Date getLastUpdateDate() {
            throw new NotSupportedException(NOT_SUPPORTED_MESSAGE);
        }
    }
}

