/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAuthorization;
import org.silverpeas.core.util.Pair;

@Service
public class TodoComponentAuthorization
implements ComponentAuthorization {
    private static final Pattern PATTERN = Pattern.compile("user@\\d+_todo");
    @Inject
    private SilverpeasCalendar calendar;

    public boolean isRelatedTo(String instanceId) {
        return PATTERN.matcher(instanceId).matches();
    }

    public <T> Stream<T> filter(Collection<T> resources, Function<T, ComponentAuthorization.ComponentResourceReference> converter, String userId, AccessControlOperation ... operations) {
        HashSet<String> todoIds = new HashSet<String>(resources.size());
        HashSet authorized = new HashSet(resources.size());
        List convertedResources = resources.stream().map(r -> {
            Pair<Object, ComponentAuthorization.ComponentResourceReference> convertedResource = this.convert(r, converter);
            ComponentAuthorization.ComponentResourceReference resourceRef = (ComponentAuthorization.ComponentResourceReference)convertedResource.getSecond();
            if ("todo".equals(resourceRef.getType())) {
                todoIds.add(resourceRef.getLocalId());
            } else {
                authorized.add(resourceRef);
            }
            return convertedResource;
        }).collect(Collectors.toList());
        Map<String, List<Attendee>> involvedUsers = this.getInvolvedUsers(todoIds);
        return convertedResources.stream().filter(p -> authorized.contains(p.getSecond()) || this.isAuthorized(userId, (ComponentAuthorization.ComponentResourceReference)p.getSecond(), involvedUsers)).map(Pair::getFirst);
    }

    private <T> Pair<T, ComponentAuthorization.ComponentResourceReference> convert(T resource, Function<T, ComponentAuthorization.ComponentResourceReference> converter) {
        return Pair.of(resource, (Object)converter.apply(resource));
    }

    private Map<String, List<Attendee>> getInvolvedUsers(Collection<String> ids) {
        return this.calendar.getToDoAttendees(ids);
    }

    private boolean isAuthorized(String userId, ComponentAuthorization.ComponentResourceReference todoRef, Map<String, List<Attendee>> allInvolvedUsers) {
        List involvedUsers = allInvolvedUsers.getOrDefault(todoRef.getLocalId(), Collections.emptyList());
        return involvedUsers.stream().anyMatch(a -> a.getUserId().equals(userId));
    }
}

