/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.personalorganizer.model.HolidayDetail;
import org.silverpeas.core.util.DateUtil;

public class HolidaysDAO {
    private static final String AGENDA_HOLIDAYS_TABLENAME = "sb_agenda_holidays";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHolidayDate(Connection con, HolidayDetail holiday) throws SQLException, UtilException {
        if (!HolidaysDAO.isHolidayDate(con, holiday)) {
            StringBuilder insertStatement = new StringBuilder(128);
            insertStatement.append("insert into ").append(AGENDA_HOLIDAYS_TABLENAME);
            insertStatement.append(" values ( ? , ? )");
            PreparedStatement prepStmt = null;
            try {
                prepStmt = con.prepareStatement(insertStatement.toString());
                prepStmt.setInt(1, Integer.parseInt(holiday.getUserId()));
                prepStmt.setString(2, DateUtil.date2SQLDate((Date)holiday.getDate()));
                prepStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        StringBuilder deleteStatement = new StringBuilder(128);
        deleteStatement.append("delete from ").append(AGENDA_HOLIDAYS_TABLENAME);
        deleteStatement.append(" where holidayDate = ? ");
        deleteStatement.append(" and userId = ? ");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(deleteStatement.toString());
            prepStmt.setString(1, DateUtil.date2SQLDate((Date)holiday.getDate()));
            prepStmt.setInt(2, Integer.parseInt(holiday.getUserId()));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolidayDate(Connection con, HolidayDetail holiday) throws SQLException {
        boolean bl;
        StringBuilder query = new StringBuilder(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where holidayDate = ? ");
        query.append(" and userId = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setString(1, DateUtil.date2SQLDate((Date)holiday.getDate()));
            stmt.setInt(2, Integer.parseInt(holiday.getUserId()));
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHolidayDates(Connection con, String userId) throws SQLException {
        ArrayList<String> holidayDates = new ArrayList<String>();
        StringBuilder query = new StringBuilder(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where userId = ? ");
        query.append("order by holidayDate ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, Integer.parseInt(userId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(rs.getString("holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHolidayDates(Connection con, String userId, Date beginDate, Date endDate) throws SQLException {
        ArrayList<String> holidayDates = new ArrayList<String>();
        StringBuilder query = new StringBuilder(128);
        query.append("select * ");
        query.append("from ").append(AGENDA_HOLIDAYS_TABLENAME);
        query.append(" where userId = ? ");
        query.append(" and ? <= holidayDate ");
        query.append(" and holidayDate <= ? ");
        query.append("order by holidayDate ASC");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(query.toString());
            stmt.setInt(1, Integer.parseInt(userId));
            stmt.setString(2, DateUtil.date2SQLDate((Date)beginDate));
            stmt.setString(3, DateUtil.date2SQLDate((Date)endDate));
            rs = stmt.executeQuery();
            while (rs.next()) {
                holidayDates.add(rs.getString("holidayDate"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return holidayDates;
    }
}

