/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs;

import java.net.URI;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.silverpeas.core.NotFoundException;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.web.WebResourceUri;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.rs.ProtectedWebResource;
import org.silverpeas.core.web.rs.RESTRequestContext;
import org.silverpeas.core.web.rs.aspect.ComponentInstMustExistIfSpecified;
import org.silverpeas.core.web.rs.aspect.WebEntityMustBeValid;

@ComponentInstMustExistIfSpecified
@WebEntityMustBeValid
public abstract class RESTWebService
implements ProtectedWebResource {
    public static final String RESPONSE_HEADER_ARRAYSIZE = "X-Silverpeas-Size";
    @Inject
    @Default
    private RESTRequestContext restRequestContext;
    @Inject
    private OrganizationController organizationController;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest httpServletRequest;
    private HttpRequest httpRequest;
    @Context
    private HttpServletResponse httpResponse;
    private Collection<SilverpeasRole> userRoles = null;
    private SilverpeasRole highestUserRole;
    private LocalizationBundle bundle = null;
    private WebResourceUri webResourceUri;

    @PostConstruct
    protected void initContext() {
        this.restRequestContext.init(this.httpServletRequest, this.httpResponse);
    }

    @Override
    public RESTRequestContext getSilverpeasContext() {
        return this.restRequestContext;
    }

    @Override
    public WebResourceUri getUri() {
        if (this.webResourceUri == null) {
            this.webResourceUri = this.initWebResourceUri();
        }
        return this.webResourceUri;
    }

    protected WebResourceUri initWebResourceUri() {
        Object path = this.getResourceBasePath();
        String componentId = this.getComponentId();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (StringUtil.isDefined((String)componentId)) {
            path = (String)path + componentId;
        }
        return new WebResourceUri((String)path, this.getHttpServletRequest(), this.uriInfo);
    }

    protected abstract String getResourceBasePath();

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpRequest getHttpRequest() {
        if (this.httpRequest == null) {
            this.httpRequest = (HttpRequest)((Object)this.getHttpServletRequest().getAttribute(HttpRequest.class.getName()));
            if (this.httpRequest == null) {
                this.httpRequest = HttpRequest.decorate(this.getHttpServletRequest());
            }
        }
        return this.httpRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpResponse;
    }

    protected boolean isUserDefined() {
        return this.getSilverpeasContext().getUser() != null;
    }

    protected User getUser() {
        return this.getSilverpeasContext().getUser();
    }

    protected UserPreferences getUserPreferences() {
        return PersonalizationServiceProvider.getPersonalizationService().getUserSettings(this.getUser().getId());
    }

    protected Collection<SilverpeasRole> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = this.organizationController.getUserSilverpeasRolesOn(this.getUser(), this.getComponentId());
        }
        return this.userRoles;
    }

    protected OrganizationController getOrganisationController() {
        return this.organizationController;
    }

    protected String getBundleLocation() {
        return null;
    }

    protected LocalizationBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = this.getBundleLocation() == null ? ResourceLocator.getGeneralLocalizationBundle((String)this.getUserPreferences().getLanguage()) : ResourceLocator.getLocalizationBundle((String)this.getBundleLocation(), (String)this.getUserPreferences().getLanguage());
        }
        return this.bundle;
    }

    public SilverpeasRole getHighestUserRole() {
        if (this.highestUserRole == null) {
            this.highestUserRole = SilverpeasRole.getHighestFrom(this.getUserRoles());
        }
        return this.highestUserRole;
    }

    protected <R> WebProcess<R> process(WebTreatment<R> webTreatment) {
        WebProcess<R> process = new WebProcess<R>(webTreatment);
        String httpMethod = this.getHttpRequest().getMethod().toUpperCase();
        if (!"GET".equals(httpMethod)) {
            process.lowestAccessRole(SilverpeasRole.WRITER);
        }
        return process;
    }

    protected URI identifiedBy(String ... id) {
        return this.identifiedBy(this.getUri().getAbsolutePathBuilder(), id);
    }

    protected URI identifiedBy(UriBuilder base, String ... id) {
        Stream.of(id).forEach(arg_0 -> ((UriBuilder)base).path(arg_0));
        return base.build(new Object[0]);
    }

    protected PaginationPage fromPage(String page) {
        PaginationPage paginationPage = null;
        if (page != null && !page.isEmpty()) {
            String[] pageAttributes = page.split(";");
            try {
                int nth = Integer.parseInt(pageAttributes[0]);
                int count = Integer.parseInt(pageAttributes[1]);
                if (count > 0) {
                    paginationPage = new PaginationPage(nth, count);
                }
            }
            catch (NumberFormatException ex) {
                SilverLogger.getLogger((Object)this).warn((Throwable)ex);
                paginationPage = PaginationPage.DEFAULT;
            }
        }
        return paginationPage;
    }

    @FunctionalInterface
    protected static interface WebTreatment<R> {
        public R execute();
    }

    protected final class WebProcess<R> {
        private final WebTreatment<R> webTreatment;
        private SilverpeasRole lowestRoleAccess = null;

        protected WebProcess(WebTreatment<R> webTreatment) {
            this.webTreatment = webTreatment;
        }

        public WebProcess<R> lowestAccessRole(SilverpeasRole lowestRoleAccess) {
            this.lowestRoleAccess = lowestRoleAccess;
            return this;
        }

        public R execute() {
            try {
                if (!(this.lowestRoleAccess == null || RESTWebService.this.getHighestUserRole() != null && RESTWebService.this.getHighestUserRole().isGreaterThanOrEquals(this.lowestRoleAccess))) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                return this.webTreatment.execute();
            }
            catch (NotFoundException ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
            }
            catch (ForbiddenRuntimeException ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.FORBIDDEN);
            }
            catch (WebApplicationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
            }
        }
    }
}

