/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.notification;

import java.util.Collection;
import java.util.Collections;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.notification.AbstractForumsMessageUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;

public class ForumsMessageValidationUserNotification
extends AbstractForumsMessageUserNotification {
    private final String moderatorId;
    private final String refusalMotive;

    public ForumsMessageValidationUserNotification(Message resource, String moderatorId) {
        this(resource, moderatorId, null);
    }

    public ForumsMessageValidationUserNotification(Message resource, String moderatorId, String refusalMotive) {
        super(resource);
        this.moderatorId = moderatorId;
        this.refusalMotive = refusalMotive;
    }

    protected String getBundleSubjectKey() {
        StringBuilder subjectKey = new StringBuilder(this.getNotificationBundleKeyPrefix());
        if (NotifAction.VALIDATE.equals((Object)this.getAction())) {
            subjectKey.append("subject.validated");
        } else {
            subjectKey.append("subject.refused");
        }
        return subjectKey.toString();
    }

    protected String getTemplateFileName() {
        if (NotifAction.VALIDATE.equals((Object)this.getAction())) {
            return "messageValidated";
        }
        return "messageRefused";
    }

    protected void perform(Message resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().setOriginalExtraMessage(this.refusalMotive);
    }

    @Override
    protected void performTemplateData(String language, Message resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("refusalMotive", (Object)this.refusalMotive);
    }

    @Override
    protected NotifAction getAction() {
        if (!StringUtil.isDefined((String)this.refusalMotive)) {
            return NotifAction.VALIDATE;
        }
        return NotifAction.REFUSE;
    }

    protected String getSender() {
        return this.moderatorId;
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(((Message)this.getResource()).getAuthor());
    }

    protected boolean isSendImmediately() {
        return true;
    }
}

