/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeSpreadsheetElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.xml.sax.SAXException;

public class OdfSpreadsheetDocument
extends OdfDocument {
    private static final String EMPTY_SPREADSHEET_DOCUMENT_PATH = "/OdfSpreadsheetDocument.ods";
    static final OdfPackageDocument.Resource EMPTY_SPREADSHEET_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfSpreadsheetDocument.ods");

    public static OdfSpreadsheetDocument newSpreadsheetDocument() throws Exception {
        return (OdfSpreadsheetDocument)OdfDocument.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.SPREADSHEET);
    }

    public static OdfSpreadsheetDocument newSpreadsheetTemplateDocument() throws Exception {
        OdfSpreadsheetDocument doc = (OdfSpreadsheetDocument)OdfDocument.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.SPREADSHEET_TEMPLATE);
        doc.changeMode(OdfMediaType.SPREADSHEET_TEMPLATE);
        return doc;
    }

    protected OdfSpreadsheetDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static OdfSpreadsheetDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfSpreadsheetDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfSpreadsheetDocument loadDocument(String documentPath) throws Exception {
        return (OdfSpreadsheetDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfSpreadsheetDocument loadDocument(File file) throws Exception {
        return (OdfSpreadsheetDocument)OdfDocument.loadDocument(file);
    }

    public OfficeSpreadsheetElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeSpreadsheetElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        SPREADSHEET(OdfDocument.OdfMediaType.SPREADSHEET),
        SPREADSHEET_TEMPLATE(OdfDocument.OdfMediaType.SPREADSHEET_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

