/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.notification;

import java.util.HashMap;
import java.util.MissingResourceException;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.notification.AbstractForumsUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public abstract class AbstractForumsMessageUserNotification
extends AbstractForumsUserNotification<Message> {
    private NotifAction action = null;

    public AbstractForumsMessageUserNotification(Message resource) {
        super(resource);
    }

    public AbstractForumsMessageUserNotification(Message resource, NotifAction action) {
        super(resource);
        this.action = action;
    }

    protected void performTemplateData(String language, Message resource, SilverpeasTemplate template) {
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)ex);
            title = this.getTitle();
        }
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("isSubject", (Object)resource.isSubject());
        template.setAttribute("title", (Object)resource.getTitle());
        template.setAttribute("text", (Object)resource.getText());
        template.setAttribute("originTitle", (Object)this.getForumsService().getMessageTitle(this.getForumsService().getMessageParentId(((Message)this.getResource()).getId())));
    }

    protected void performNotificationResource(String language, Message resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(false);
        notificationResourceData.setResourceId((Number)resource.getId());
        notificationResourceData.setResourceType(resource.getResourceType());
        notificationResourceData.setResourceName(resource.getTitle());
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((Message)this.getResource()).getInstanceId();
    }

    protected String getResourceURL(Message resource) {
        int initialSize = 2;
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("componentId", this.getComponentInstanceId());
        params.put("messageId", resource.getIdAsString());
        return StringUtil.format((String)this.settings.getString("forums.message.link"), params);
    }

    protected String getNotificationBundleKeyPrefix() {
        StringBuilder bundleKeyPrefix = new StringBuilder("forums.");
        if (((Message)this.getResource()).isSubject()) {
            bundleKeyPrefix.append("subject");
        } else {
            bundleKeyPrefix.append("message");
        }
        return bundleKeyPrefix.append(".notification.").toString();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return this.getNotificationBundleKeyPrefix() + "notifLinkLabel";
    }
}

