/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.repository;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.model.SuggestionCriteria;
import org.silverpeas.components.suggestionbox.model.SuggestionCriteriaProcessor;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.Parameters;
import org.silverpeas.core.persistence.datasource.repository.QueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.SimpleQueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;

public class JPQLQueryBuilder
implements SuggestionCriteriaProcessor {
    private StringBuilder orderBy = null;
    private boolean done = false;
    private final SimpleQueryCriteria jpqlCriteria;
    private String conjonction;

    public JPQLQueryBuilder(NamedParameters parameters) {
        this.jpqlCriteria = new SimpleQueryCriteria((Parameters)parameters);
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void endProcessing() {
        if (this.orderBy != null && this.orderBy.length() > 0) {
            this.jpqlCriteria.clause().add(this.orderBy.toString());
        }
        this.done = true;
    }

    public QueryCriteria result() {
        return this.jpqlCriteria;
    }

    @Override
    public SuggestionCriteriaProcessor then() {
        if (!this.done) {
            this.conjonction = "and";
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processSuggestionBox(SuggestionBox box) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("suggestionBox = :suggestionBox").parameters().add("suggestionBox", (Object)box);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processCreator(User creator) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("createdBy = :createdBy").parameters().add("createdBy", (Object)creator.getId());
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processStatus(List<ContributionStatus> status) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("validation.status in :statuses").parameters().add("statuses", status);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processJoinDataApply(List<SuggestionCriteria.JOIN_DATA_APPLY> joinDataApplies) {
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processOrdering(List<SuggestionCriteria.QUERY_ORDER_BY> orderings) {
        if (!this.done) {
            for (SuggestionCriteria.QUERY_ORDER_BY anOrdering : orderings) {
                if (!anOrdering.isApplicableOnJpaQuery()) continue;
                if (this.orderBy == null) {
                    this.orderBy = new StringBuilder("order by ");
                } else {
                    this.orderBy.append(", ");
                }
                this.orderBy.append(anOrdering.getPropertyName());
                this.orderBy.append(" ");
                this.orderBy.append(anOrdering.isAsc() ? "asc" : "desc");
            }
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processIdentifiers(List<String> identifiers) {
        if (!this.done) {
            ArrayList<UuidIdentifier> uuids = new ArrayList<UuidIdentifier>(identifiers.size());
            for (String id : identifiers) {
                uuids.add(new UuidIdentifier().fromString(id));
            }
            this.jpqlCriteria.clause().add(this.conjonction).add("id in :ids").parameters().add("ids", uuids);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SuggestionCriteriaProcessor processPagination(PaginationPage pagination) {
        this.jpqlCriteria.withPagination(new PaginationCriterion(pagination.getPageNumber(), pagination.getPageSize()));
        this.conjonction = null;
        return this;
    }
}

